/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.csv.Column;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.ImportEvent;
import de.willuhn.jameica.hbci.io.csv.ImportListener;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.List;

public class AddressFormat
implements Format<HibiscusAddress> {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ImportListener listener = null;
    private Profile profile = null;

    @Override
    public synchronized Profile getDefaultProfile() {
        if (this.profile == null) {
            this.profile = new Profile();
            this.profile.setName(i18n.tr("Default-Profil"));
            this.profile.setSkipLines(1);
            this.profile.setSystem(true);
            DefaultSerializer s = new DefaultSerializer();
            List<Column> list = this.profile.getColumns();
            int i = 0;
            list.add(new Column("name", i18n.tr("Name des Kontoinhabers"), i++, s));
            list.add(new Column("kontonummer", i18n.tr("Kontonummer"), i++, s));
            list.add(new Column("blz", i18n.tr("Bankleitzahl"), i++, s));
            list.add(new Column("iban", i18n.tr("IBAN"), i++, s));
            list.add(new Column("bic", i18n.tr("BIC"), i++, s));
            list.add(new Column("kommentar", i18n.tr("Notiz"), i++, s));
        }
        return this.profile;
    }

    @Override
    public Class<HibiscusAddress> getType() {
        return HibiscusAddress.class;
    }

    @Override
    public ImportListener getImportListener() {
        if (this.listener == null) {
            this.listener = new ImportListener(){
                private AddressbookService addressbook = null;

                @Override
                public void beforeStore(ImportEvent event) throws OperationCanceledException {
                    try {
                        HibiscusAddress t;
                        Object data = event.data;
                        if (data == null || !(data instanceof HibiscusAddress)) {
                            return;
                        }
                        if (this.addressbook == null) {
                            this.addressbook = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
                        }
                        if (this.addressbook.contains(t = (HibiscusAddress)data) != null) {
                            throw new OperationCanceledException(i18n.tr("Adresse (Kto {0}, BLZ {1}) existiert bereits, \u00fcberspringe Zeile", new String[]{t.getKontonummer(), t.getBlz()}));
                        }
                    }
                    catch (OperationCanceledException oce) {
                        throw oce;
                    }
                    catch (Exception e) {
                        Logger.write((Level)Level.WARN, (String)"error while checking address", (Throwable)e);
                    }
                }
            };
        }
        return this.listener;
    }
}

