/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.CSVImportDialog;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.io.csv.Column;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.ImportEvent;
import de.willuhn.jameica.hbci.io.csv.ImportListener;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ClassFinder;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CsvImporter
implements Importer {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        CsvListReader csv = null;
        try {
            if (is == null) {
                throw new ApplicationException(i18n.tr("Keine zu importierende Datei ausgew\u00e4hlt"));
            }
            if (format == null) {
                throw new ApplicationException(i18n.tr("Kein Datei-Format ausgew\u00e4hlt"));
            }
            if (!(format instanceof MyIOFormat)) {
                throw new ApplicationException(i18n.tr("Das Datei-Format ist unbekannt"));
            }
            Format f = ((MyIOFormat)format).format;
            monitor.setStatusText(i18n.tr("\u00d6ffne Datei"));
            monitor.addPercentComplete(1);
            byte[] data = CsvImporter.copy(is);
            if (data == null || data.length == 0) {
                throw new ApplicationException(i18n.tr("CSV-Datei enth\u00e4lt keine Daten"));
            }
            CSVImportDialog d = new CSVImportDialog(data, f, 1);
            Profile p = (Profile)d.open();
            CsvPreference prefs = p.createCsvPreference();
            Charset charset = null;
            try {
                charset = Charset.forName(p.getFileEncoding());
            }
            catch (UnsupportedCharsetException e) {
                Logger.warn((String)("unsupported charset: " + p.getFileEncoding()));
            }
            csv = new CsvListReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), charset != null ? charset : Charset.defaultCharset()), prefs);
            List line = csv.read();
            int i = 0;
            while (i < p.getSkipLines()) {
                line = csv.read();
                ++i;
            }
            if (line == null || line.size() == 0) {
                throw new ApplicationException(i18n.tr("CSV-Datei enth\u00e4lt keine weiteren Daten"));
            }
            int created = 0;
            int error = 0;
            int skipped = 0;
            DBObject object = null;
            String value = null;
            List<Column> cols = p.getColumns();
            ImportListener l = f.getImportListener();
            DBService service = (DBService)Application.getServiceFactory().lookup(HBCI.class, "database");
            do {
                monitor.log(i18n.tr("Importiere Zeile {0}", Integer.toString(csv.getLineNumber())));
                monitor.addPercentComplete(1);
                try {
                    if (t != null && t.isInterrupted()) {
                        throw new OperationCanceledException();
                    }
                    object = service.createObject(f.getType(), null);
                    HashMap values = new HashMap();
                    int i2 = 0;
                    while (i2 < line.size()) {
                        Column column = null;
                        for (Column c : cols) {
                            if (c.getColumn() != i2) continue;
                            column = c;
                            break;
                        }
                        if (column != null && (value = (String)line.get(i2)) != null && (value = value.trim()).length() != 0) {
                            try {
                                Object prev = values.get(column.getProperty());
                                values.put(column.getProperty(), column.getSerializer().unserialize(prev, value));
                            }
                            catch (Exception e) {
                                Logger.error((String)("unable to unserialize " + column.getProperty() + " for line " + csv.getLineNumber() + ", value: " + value), (Throwable)e);
                                monitor.log("  " + i18n.tr("Ung\u00fcltiger Wert \"{0}\" in Spalte \"{1}\": {2}", new String[]{value, column.getName(), e.getMessage()}));
                            }
                        }
                        ++i2;
                    }
                    if (l != null) {
                        ImportEvent e = new ImportEvent();
                        e.context = context;
                        e.data = values;
                        try {
                            l.beforeSet(e);
                        }
                        catch (OperationCanceledException oce) {
                            ++skipped;
                            String msg = oce.getMessage();
                            if (msg == null || msg.length() <= 0) continue;
                            monitor.log("  " + msg);
                            continue;
                        }
                    }
                    for (String name : values.keySet()) {
                        Object o = values.get(name);
                        try {
                            BeanUtil.set((Object)object, (String)name, o);
                        }
                        catch (Exception e) {
                            Logger.error((String)("unable to apply property " + name + " for line " + csv.getLineNumber() + ", value: " + o), (Throwable)e);
                            String[] s = new String[]{value, name, e.getMessage()};
                            monitor.log("  " + i18n.tr("Ung\u00fcltiger Wert \"{0}\" in Spalte \"{1}\": {2}", s));
                        }
                    }
                    if (l != null) {
                        ImportEvent e = new ImportEvent();
                        e.context = context;
                        e.data = object;
                        try {
                            l.beforeStore(e);
                        }
                        catch (OperationCanceledException oce) {
                            ++skipped;
                            String msg = oce.getMessage();
                            if (msg == null || msg.length() <= 0) continue;
                            monitor.log("  " + msg);
                            continue;
                        }
                    }
                    object.store();
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)object));
                    ++created;
                }
                catch (Exception e) {
                    if (!(e instanceof ApplicationException)) {
                        Logger.error((String)"unable to import line", (Throwable)e);
                    }
                    monitor.log("  " + i18n.tr("Fehler in Zeile {0}: {1}", new String[]{Integer.toString(csv.getLineNumber()), e.getMessage()}));
                    ++error;
                }
            } while ((line = csv.read()) != null);
            monitor.setStatusText(i18n.tr("{0} importiert, {1} fehlerhaft, {2} \u00fcbersprungen", new String[]{Integer.toString(created), Integer.toString(error), Integer.toString(skipped)}));
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof SWTException && e.getCause() instanceof OperationCanceledException) {
                Logger.info((String)"operation cancelled");
                monitor.setStatus(5);
                monitor.setStatusText(i18n.tr("Import abgebrochen"));
                IOUtil.close((Closeable[])new Closeable[]{csv});
                return;
            }
            try {
                Logger.error((String)"error while reading file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Lesen der CSV-Datei"));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{csv});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{csv});
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        ArrayList<MyIOFormat> formats = new ArrayList<MyIOFormat>();
        try {
            Class[] classes;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ClassFinder finder = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader().getClassFinder();
            Class[] classArray = classes = finder.findImplementors(Format.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Format f = (Format)service.get(c);
                    Class type = f.getType();
                    if (type == null) {
                        Logger.warn((String)("csv format " + c.getName() + " supports no type, skipping"));
                    } else if (type.equals(objectType)) {
                        formats.add(new MyIOFormat(f));
                    }
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e2) {
            Logger.error((String)"no csv formats found");
        }
        return formats.toArray(new IOFormat[0]);
    }

    @Override
    public String getName() {
        return i18n.tr("CSV-Format");
    }

    private static byte[] copy(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) != -1) {
                if (read <= 0) continue;
                bos.write(buf, 0, read);
            }
            return bos.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class MyIOFormat
    implements IOFormat {
        private Format format = null;

        private MyIOFormat(Format f) {
            this.format = f;
        }

        @Override
        public String getName() {
            return CsvImporter.this.getName();
        }

        @Override
        public String[] getFileExtensions() {
            return new String[]{"*.csv", "*.txt"};
        }
    }
}

