/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.jameica.hbci.io.csv.Column;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.prefs.CsvPreference;

public class Profile
implements Serializable,
Comparable {
    private String name = null;
    private boolean system = false;
    private List<Column> columns = new ArrayList<Column>();
    private String separatorChar = ";";
    private String quotingChar = "\"";
    private int skipLines = 0;
    private String fileEncoding = System.getProperty("file.encoding");

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public String getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(String s) {
        this.separatorChar = s != null && s.length() == 1 ? s : ";";
    }

    public String getQuotingChar() {
        return this.quotingChar;
    }

    public void setQuotingChar(String s) {
        this.quotingChar = s != null && s.length() == 1 ? s : "";
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int i) {
        if (i >= 0) {
            this.skipLines = i;
        }
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String s) {
        if (s != null && s.length() > 0) {
            this.fileEncoding = s;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public CsvPreference createCsvPreference() {
        CsvPreference prefs = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
        int sc = prefs.getDelimiterChar();
        char qc = prefs.getQuoteChar();
        String sep = this.getSeparatorChar();
        String quo = this.getQuotingChar();
        if (sep != null && sep.length() == 1) {
            sc = sep.charAt(0);
        }
        if (quo != null && quo.length() == 1) {
            qc = quo.charAt(0);
        }
        CsvPreference.Builder builder = new CsvPreference.Builder(qc, sc, prefs.getEndOfLineSymbols());
        return builder.build();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        return this.getName() != null && this.getName().equals(other.getName());
    }

    public int compareTo(Object o) {
        if (this.isSystem()) {
            return -1;
        }
        Profile other = (Profile)o;
        if (other.isSystem()) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + ", encoding: " + this.getFileEncoding() + ", separator: " + this.getSeparatorChar() + ", quoting char: " + this.getQuotingChar() + ", skip lines: " + this.getSkipLines();
    }
}

