/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.CSVProfileStoreDialog;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ProfileUtil {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static List<Profile> read(Format format) {
        ArrayList<Profile> result = new ArrayList<Profile>();
        if (format == null) {
            Logger.warn((String)"no format given");
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Kein Format ausgew\u00e4hlt"), 1));
            return result;
        }
        Profile dp = format.getDefaultProfile();
        result.add(dp);
        File dir = new File(Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath(), "csv");
        if (!dir.exists()) {
            return result;
        }
        File file = new File(dir, String.valueOf(format.getClass().getName()) + ".xml");
        if (!file.exists() || !file.canRead()) {
            return result;
        }
        Logger.info((String)("reading csv profile " + file));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));){
                decoder.setExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                try {
                    int i = 0;
                    while (i < 1000) {
                        Profile p = (Profile)decoder.readObject();
                        if (StringUtils.trimToNull((String)p.getName()) == null) {
                            p.setName(String.valueOf(dp.getName()) + " 2");
                            p.setSystem(false);
                        }
                        result.add(p);
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                Logger.info((String)("read " + (result.size() - 1) + " profiles from " + file));
                Collections.sort(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to read profile " + file), (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Laden der Profile fehlgeschlagen: {0}", e.getMessage()), 1));
        }
        return result;
    }

    public static void store(Format format, List<Profile> profiles) {
        if (format == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Kein Format ausgew\u00e4hlt"), 1));
            return;
        }
        if (profiles == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Keine Profile angegeben"), 1));
            return;
        }
        File dir = new File(Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath(), "csv");
        if (!dir.exists()) {
            Logger.info((String)("creating dir: " + dir));
            if (!dir.mkdirs()) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Ordner {0} kann nicht erstellt werden", dir.getAbsolutePath()), 1));
                return;
            }
        }
        File file = new File(dir, String.valueOf(format.getClass().getName()) + ".xml");
        Logger.info((String)("writing csv profile " + file));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));){
                encoder.setExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                for (Profile p : profiles) {
                    if (p.isSystem() || StringUtils.trimToNull((String)p.getName()) == null) continue;
                    encoder.writeObject(p);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to store profile " + file), (Throwable)e);
        }
    }

    public static Profile add(Format format, Profile profile) {
        block4: {
            if (profile != null && format != null) break block4;
            Application.getCallback().notifyUser(i18n.tr("Kein Profil angegeben"));
            return null;
        }
        try {
            CSVProfileStoreDialog d = new CSVProfileStoreDialog(format, profile);
            return (Profile)d.open();
        }
        catch (OperationCanceledException d) {
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete profile", (Throwable)e);
        }
        return null;
    }

    public static boolean delete(Format format, Profile profile) {
        List<Profile> profiles2;
        block8: {
            block7: {
                if (profile == null || format == null) {
                    return false;
                }
                if (!profile.isSystem()) break block7;
                Application.getCallback().notifyUser(i18n.tr("Das Default-Profil darf nicht gel\u00f6scht werden"));
                return false;
            }
            profiles2 = ProfileUtil.read(format);
            boolean found = false;
            for (Profile p : profiles2) {
                if (p.isSystem() || !p.getName().equals(profile.getName())) continue;
                profiles2.remove(p);
                found = true;
                break;
            }
            if (found) break block8;
            return false;
        }
        try {
            ProfileUtil.store(format, profiles2);
            return true;
        }
        catch (OperationCanceledException profiles2) {
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete profile", (Throwable)e);
        }
        return false;
    }
}

