/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.csv.Column;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.ImportEvent;
import de.willuhn.jameica.hbci.io.csv.ImportListener;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.io.ser.DateSerializer;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.hbci.io.ser.ExtendedUsageSerializer;
import de.willuhn.jameica.hbci.io.ser.UmsatzTypSerializer;
import de.willuhn.jameica.hbci.io.ser.ValueSerializer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.List;

public class UmsatzFormat
implements Format<Umsatz> {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ImportListener listener = null;
    private Profile profile = null;

    @Override
    public synchronized Profile getDefaultProfile() {
        if (this.profile == null) {
            this.profile = new Profile();
            this.profile.setName(i18n.tr("Default-Profil"));
            this.profile.setSkipLines(1);
            this.profile.setSystem(true);
            DefaultSerializer ts = new DefaultSerializer();
            ValueSerializer vs = new ValueSerializer();
            DateSerializer ds = new DateSerializer();
            List<Column> list = this.profile.getColumns();
            int i = 4;
            list.add(new Column("gegenkontoNummer", i18n.tr("Gegenkonto IBAN"), i++, ts));
            list.add(new Column("gegenkontoBLZ", i18n.tr("Gegenkonto BIC"), i++, ts));
            list.add(new Column("gegenkontoName", i18n.tr("Gegenkonto"), i++, ts));
            list.add(new Column("betrag", i18n.tr("Betrag"), i++, vs));
            list.add(new Column("valuta", i18n.tr("Valuta"), i++, ds));
            list.add(new Column("datum", i18n.tr("Datum"), i++, ds));
            list.add(new Column("zweck", i18n.tr("Verwendungszweck"), i++, ts));
            list.add(new Column("zweck2", i18n.tr("Verwendungszweck 2"), i++, ts));
            list.add(new Column("saldo", i18n.tr("Saldo"), i++, vs));
            list.add(new Column("primanota", i18n.tr("Primanota"), i++, ts));
            list.add(new Column("customerRef", i18n.tr("Kundenreferenz"), i++, ts));
            list.add(new Column("umsatzTyp", i18n.tr("Kategorie"), i++, new UmsatzTypSerializer()));
            list.add(new Column("kommentar", i18n.tr("Notiz"), i++, ts));
            list.add(new Column("weitereVerwendungszwecke", i18n.tr("Weitere Verwendungszwecke"), i++, new ExtendedUsageSerializer()));
            list.add(new Column("art", i18n.tr("Art der Buchung"), i++, ts));
            list.add(new Column("endToEndId", i18n.tr("End-to-End ID"), i++, ts));
            list.add(new Column("mandateid", i18n.tr("Kunden-/Mandatsreferenz"), i++, ts));
        }
        return this.profile;
    }

    @Override
    public Class<Umsatz> getType() {
        return Umsatz.class;
    }

    @Override
    public ImportListener getImportListener() {
        if (this.listener == null) {
            this.listener = new ImportListener(){

                @Override
                public void beforeStore(ImportEvent event) {
                    try {
                        Object context;
                        Object data = event.data;
                        if (data == null || !(data instanceof Umsatz)) {
                            return;
                        }
                        Umsatz u = (Umsatz)data;
                        Date dd = u.getDatum();
                        Date dv = u.getValuta();
                        if (dd == null) {
                            u.setDatum(dv);
                        }
                        if (dv == null) {
                            u.setValuta(dd);
                        }
                        if ((context = event.context) != null && context instanceof Konto) {
                            u.setKonto((Konto)context);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while assigning account", (Throwable)e);
                    }
                }
            };
        }
        return this.listener;
    }
}

