/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import net.sf.paperclips.AlignPrint;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.ImagePrint;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.LinePrint;
import net.sf.paperclips.Margins;
import net.sf.paperclips.PageDecoration;
import net.sf.paperclips.PageNumberPageDecoration;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintJob;
import net.sf.paperclips.SimplePageDecoration;
import net.sf.paperclips.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractPrintSupport
implements PrintSupport {
    private static final Settings settings = new Settings(PrintSupport.class);
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    FontData fontTitle = Font.BOLD.getSWTFont().getFontData()[0];
    FontData fontNormal = Font.DEFAULT.getSWTFont().getFontData()[0];
    FontData fontBold = new FontData(this.fontNormal.getName(), this.fontNormal.getHeight(), 1);
    FontData fontTiny = Font.SMALL.getSWTFont().getFontData()[0];
    FontData fontTinyBold = new FontData(this.fontTiny.getName(), this.fontTiny.getHeight(), 1);

    public PrintJob print() throws ApplicationException {
        Print content = this.printContent();
        GridPrint grid = new GridPrint("l:d:g");
        grid.add((Print)new TextPrint(this.getTitle(), this.fontTitle));
        grid.add((Print)new LinePrint());
        grid.add((Print)new LineBreakPrint(this.fontTitle));
        grid.add(content);
        PagePrint page = new PagePrint((Print)grid);
        DefaultGridLook look = new DefaultGridLook(5, 5);
        GridPrint table = new GridPrint("l:p:g, r:p:g", (GridLook)look);
        table.add((Print)new TextPrint(i18n.tr("Druck: {0}", HBCI.LONGDATEFORMAT.format(new Date())), this.fontTiny));
        ImagePrint ip = new ImagePrint(SWTUtil.getImage((String)"hibiscus-print.png").getImageData(), new Point(300, 300));
        table.add((Print)new AlignPrint((Print)ip, 131072, 128));
        page.setHeader((PageDecoration)new SimplePageDecoration((Print)table));
        PageNumberPageDecoration footer = new PageNumberPageDecoration(131072);
        footer.setFontData(this.fontTiny);
        page.setFooter((PageDecoration)footer);
        this.customize(page);
        PrintJob job = new PrintJob(i18n.tr("Hibiscus {0}", HBCI.LONGDATEFORMAT.format(new Date())), (Print)page);
        Margins margins = job.getMargins();
        margins.left = settings.getInt("margin.left", 100);
        margins.right = settings.getInt("margin.right", 50);
        return job;
    }

    abstract Print printContent() throws ApplicationException;

    abstract String getTitle() throws ApplicationException;

    void customize(PagePrint page) throws ApplicationException {
    }

    String notNull(Object value) throws RemoteException {
        String empty = "-";
        if (value == null) {
            return empty;
        }
        String s = value.toString();
        return s != null && s.trim().length() > 0 ? s : empty;
    }
}

