/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.EmptyPrint;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;

public abstract class AbstractPrintSupportBaseUeberweisung
extends AbstractPrintSupport {
    private BaseUeberweisung auftrag = null;

    public AbstractPrintSupportBaseUeberweisung(BaseUeberweisung a) {
        this.auftrag = a;
    }

    @Override
    Print printContent() throws ApplicationException {
        if (this.auftrag == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        try {
            BaseUeberweisung a = this.auftrag;
            Konto k = a.getKonto();
            DefaultGridLook look = new DefaultGridLook(5, 5);
            GridPrint table = new GridPrint("l:p:n, l:d:g", (GridLook)look);
            table.add((Print)new TextPrint(i18n.tr("Konto"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(k != null ? k.getLongName() : null), this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            String blz = a.getGegenkontoBLZ();
            table.add((Print)new TextPrint(i18n.tr("Gegenkonto"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(a.getGegenkontoName()), this.fontBold));
            table.add((Print)new EmptyPrint());
            if (blz != null && blz.length() > 0) {
                table.add((Print)new TextPrint(i18n.tr("{0} [BLZ: {1}]\nKonto: {2}", new String[]{this.notNull(HBCIProperties.getNameForBank(blz)), blz, this.notNull(a.getGegenkontoNummer())}), this.fontNormal));
            } else {
                table.add((Print)new EmptyPrint());
            }
            table.add((Print)new LineBreakPrint(this.fontTiny));
            table.add((Print)new LineBreakPrint(this.fontTiny));
            table.add((Print)new TextPrint(i18n.tr("Verwendungszweck"), this.fontNormal));
            table.add((Print)new TextPrint(VerwendungszweckUtil.toString(a, "\n"), this.fontNormal));
            double betrag = a.getBetrag();
            String curr = k != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE;
            table.add((Print)new TextPrint(i18n.tr("Betrag"), this.fontNormal));
            table.add((Print)new TextPrint(betrag == 0.0 || Double.isNaN(betrag) ? "-" : String.valueOf(HBCI.DECIMALFORMAT.format(betrag)) + " " + curr, this.fontBold));
            table.add((Print)new LineBreakPrint(this.fontTiny));
            table.add((Print)new LineBreakPrint(this.fontTiny));
            table.add((Print)new TextPrint(i18n.tr("Textschl\u00fcssel"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(TextSchluessel.get(a.getTextSchluessel())), this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontTiny));
            table.add((Print)new LineBreakPrint(this.fontTiny));
            Date termin = a.getTermin();
            table.add((Print)new TextPrint(i18n.tr("Erinnerungstermin"), this.fontNormal));
            table.add((Print)new TextPrint(termin == null ? "-" : HBCI.DATEFORMAT.format(termin), this.fontNormal));
            Date ausgefuehrt = a.getAusfuehrungsdatum();
            table.add((Print)new TextPrint(i18n.tr("Ausgef\u00fchrt"), this.fontNormal));
            if (ausgefuehrt != null) {
                table.add((Print)new TextPrint(HBCI.DATEFORMAT.format(ausgefuehrt), this.fontBold));
            } else {
                table.add((Print)new TextPrint(a.ausgefuehrt() ? "Ja" : "Nein", this.fontBold));
            }
            this.customize(table);
            return table;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }

    void customize(GridPrint grid) throws RemoteException, ApplicationException {
    }

    @Override
    void customize(PagePrint page) throws ApplicationException {
        page.setFooter(null);
    }
}

