/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.TextSchluessel;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import net.sf.paperclips.Border;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractPrintSupportSammelTransfer
extends AbstractPrintSupport {
    private Object ctx = null;

    public AbstractPrintSupportSammelTransfer(Object ctx) {
        this.ctx = ctx;
    }

    @Override
    Print printContent() throws ApplicationException {
        Object data = this.ctx;
        if (data == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        if (data instanceof TablePart) {
            data = ((TablePart)data).getSelection();
        }
        if (!(data instanceof SammelTransfer)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        try {
            SammelTransfer a = (SammelTransfer)data;
            Konto k = a.getKonto();
            GridPrint grid = new GridPrint("l:d:g");
            DefaultGridLook look = new DefaultGridLook(5, 5);
            GridPrint table = new GridPrint("l:p:n, l:d:g", (GridLook)look);
            table.add((Print)new TextPrint(i18n.tr("Bezeichnung"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(a.getBezeichnung()), this.fontBold));
            table.add((Print)new TextPrint(i18n.tr("Konto"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(k != null ? k.getLongName() : null), this.fontNormal));
            Date termin = a.getTermin();
            table.add((Print)new TextPrint(i18n.tr("Erinnerungstermin"), this.fontNormal));
            table.add((Print)new TextPrint(termin == null ? "-" : HBCI.DATEFORMAT.format(termin), this.fontNormal));
            table.add((Print)new TextPrint(i18n.tr("Summe"), this.fontNormal));
            table.add((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(a.getSumme())) + " " + k.getWaehrung(), this.fontBold));
            Date ausgefuehrt = a.getAusfuehrungsdatum();
            table.add((Print)new TextPrint(i18n.tr("Ausgef\u00fchrt"), this.fontNormal));
            if (ausgefuehrt != null) {
                table.add((Print)new TextPrint(HBCI.DATEFORMAT.format(ausgefuehrt), this.fontBold));
            } else {
                table.add((Print)new TextPrint(a.ausgefuehrt() ? "Ja" : "Nein", this.fontBold));
            }
            grid.add((Print)table);
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            grid.add((Print)new TextPrint(i18n.tr("Enthaltene Buchungen"), this.fontBold));
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            DBIterator buchungen = a.getBuchungen();
            if (buchungen.size() > 0) {
                DefaultGridLook look2 = new DefaultGridLook();
                look2.setHeaderBackground(new RGB(220, 220, 220));
                LineBorder border = new LineBorder(new RGB(100, 100, 100));
                border.setGapSize(3);
                look2.setCellBorder((Border)border);
                GridPrint table2 = new GridPrint("r:d:n, l:d:n, l:p:g, l:p:n, r:p:n", (GridLook)look2);
                table2.addHeader((Print)new TextPrint(i18n.tr("Nr."), this.fontTinyBold));
                table2.addHeader((Print)new TextPrint(i18n.tr("Gegenkonto"), this.fontTinyBold));
                table2.addHeader((Print)new TextPrint(i18n.tr("Zweck"), this.fontTinyBold));
                table2.addHeader((Print)new TextPrint(i18n.tr("Typ"), this.fontTinyBold));
                table2.addHeader((Print)new TextPrint(i18n.tr("Betrag"), this.fontTinyBold));
                int count = 0;
                while (buchungen.hasNext()) {
                    SammelTransferBuchung b = (SammelTransferBuchung)buchungen.next();
                    String usage = VerwendungszweckUtil.toString(b, "\n");
                    table2.add((Print)new TextPrint(Integer.toString(++count), this.fontTiny));
                    table2.add((Print)new TextPrint(i18n.tr("{0}, Kto. {1}, BLZ {2}", new String[]{b.getGegenkontoName(), b.getGegenkontoNummer(), b.getGegenkontoBLZ()}), this.fontTiny));
                    table2.add((Print)new TextPrint(usage, this.fontTiny));
                    table2.add((Print)new TextPrint(this.notNull(TextSchluessel.get(b.getTextSchluessel())), this.fontTiny));
                    table2.add((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(b.getBetrag())) + " " + k.getWaehrung(), this.fontTiny));
                }
                grid.add((Print)table2);
            } else {
                grid.add((Print)new TextPrint("- " + i18n.tr("keine") + " -", this.fontTiny));
            }
            return grid;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }
}

