/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import net.sf.paperclips.Border;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.EmptyPrint;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractPrintSupportSepaSammelTransfer<T extends SepaSammelTransfer>
extends AbstractPrintSupport {
    private Object ctx = null;

    public AbstractPrintSupportSepaSammelTransfer(Object ctx) {
        this.ctx = ctx;
    }

    @Override
    Print printContent() throws ApplicationException {
        T a = this.getAuftrag();
        try {
            Konto k = a.getKonto();
            GridPrint grid = new GridPrint("l:d:g");
            GridPrint table = this.createTransferTable(a);
            grid.add((Print)table);
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            grid.add((Print)new TextPrint(i18n.tr("Enthaltene Buchungen"), this.fontBold));
            grid.add((Print)new LineBreakPrint(this.fontNormal));
            List buchungen = a.getBuchungen();
            if (buchungen.size() > 0) {
                DefaultGridLook look = new DefaultGridLook();
                look.setHeaderBackground(new RGB(220, 220, 220));
                LineBorder border = new LineBorder(new RGB(100, 100, 100));
                border.setGapSize(3);
                look.setCellBorder((Border)border);
                GridPrint children = new GridPrint("r:d:n, l:d:n, l:d:n, r:p:n", (GridLook)look);
                children.addHeader((Print)new TextPrint(i18n.tr("Nr."), this.fontTinyBold));
                children.addHeader((Print)new TextPrint(i18n.tr("Gegenkonto"), this.fontTinyBold));
                children.addHeader((Print)new TextPrint(i18n.tr("Zweck"), this.fontTinyBold));
                children.addHeader((Print)new TextPrint(i18n.tr("Betrag"), this.fontTinyBold));
                int count = 0;
                for (SepaSammelTransferBuchung b : buchungen) {
                    children.add((Print)new TextPrint(Integer.toString(++count), this.fontTiny));
                    String bic = b.getGegenkontoBLZ();
                    String bank = HBCIProperties.getNameForBank(bic);
                    String text = String.valueOf(b.getGegenkontoName()) + ", IBAN " + HBCIProperties.formatIban(b.getGegenkontoNummer());
                    if (StringUtils.trimToNull((String)bic) != null) {
                        text = String.valueOf(text) + ", BIC " + bic;
                    }
                    if (StringUtils.trimToNull((String)bank) != null) {
                        text = String.valueOf(text) + " (" + bank + ")";
                    }
                    children.add((Print)new TextPrint(text, this.fontTiny));
                    children.add((Print)new TextPrint(VerwendungszweckUtil.toString(b, "\n"), this.fontTiny));
                    children.add((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(b.getBetrag())) + " " + k.getWaehrung(), this.fontTiny));
                }
                grid.add((Print)children);
            } else {
                grid.add((Print)new TextPrint("- " + i18n.tr("keine") + " -", this.fontTiny));
            }
            return grid;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }

    protected T getAuftrag() throws ApplicationException {
        Object data = this.ctx;
        if (data == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        if (data instanceof TablePart) {
            data = ((TablePart)data).getSelection();
        }
        if (!(data instanceof SepaSammelTransfer)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        return (T)((SepaSammelTransfer)data);
    }

    GridPrint createTransferTable(T a) throws RemoteException, ApplicationException {
        Konto k = a.getKonto();
        DefaultGridLook look = new DefaultGridLook(5, 5);
        GridPrint table = new GridPrint("l:p:n, l:d:g", (GridLook)look);
        table.add((Print)new TextPrint(i18n.tr("Bezeichnung"), this.fontNormal));
        table.add((Print)new TextPrint(this.notNull(a.getBezeichnung()), this.fontBold));
        table.add((Print)new TextPrint(i18n.tr("Konto"), this.fontNormal));
        table.add((Print)new TextPrint(this.notNull(k != null ? k.getLongName() : null), this.fontNormal));
        table.add((Print)new EmptyPrint());
        table.add((Print)new TextPrint(i18n.tr("IBAN: {0}", k.getIban()), this.fontNormal));
        boolean bankSide = false;
        if (a instanceof SepaSammelUeberweisung) {
            SepaSammelUeberweisung au = (SepaSammelUeberweisung)a;
            bankSide = au.isTerminUeberweisung();
        }
        if (bankSide) {
            table.add((Print)new TextPrint(i18n.tr("Auftragsart"), this.fontNormal));
            table.add((Print)new TextPrint(i18n.tr("Bankseitiger Terminauftrag"), this.fontNormal));
        }
        Date termin = a.getTermin();
        table.add((Print)new TextPrint(i18n.tr(bankSide ? "Ausf\u00fchrungstermin" : "Erinnerungstermin"), this.fontNormal));
        table.add((Print)new TextPrint(termin == null ? "-" : HBCI.DATEFORMAT.format(termin), this.fontNormal));
        table.add((Print)new TextPrint(i18n.tr("Summe"), this.fontNormal));
        table.add((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(a.getSumme())) + " " + k.getWaehrung(), this.fontBold));
        Date ausgefuehrt = a.getAusfuehrungsdatum();
        table.add((Print)new TextPrint(i18n.tr(bankSide ? "Eingereicht" : "Ausgef\u00fchrt"), this.fontNormal));
        if (ausgefuehrt != null) {
            table.add((Print)new TextPrint(HBCI.DATEFORMAT.format(ausgefuehrt), this.fontBold));
        } else {
            table.add((Print)new TextPrint(a.ausgefuehrt() ? "Ja" : "Nein", this.fontBold));
        }
        return table;
    }
}

