/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import net.sf.paperclips.Border;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;
import net.sf.paperclips.TextStyle;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractPrintSupportSepaTransferList
extends AbstractPrintSupport {
    private Object ctx = null;

    public AbstractPrintSupportSepaTransferList(Object ctx) {
        this.ctx = ctx;
    }

    Object getContext() {
        return this.ctx;
    }

    @Override
    Print printContent() throws ApplicationException {
        Object data = this.getContext();
        if (data instanceof TablePart) {
            data = ((TablePart)data).getSelection();
        }
        if (!(data instanceof BaseUeberweisung[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens einen Auftrag aus"));
        }
        try {
            DefaultGridLook look = new DefaultGridLook();
            look.setHeaderBackground(new RGB(220, 220, 220));
            LineBorder border = new LineBorder(new RGB(100, 100, 100));
            border.setGapSize(3);
            look.setCellBorder((Border)border);
            GridPrint table = new GridPrint("l:p:n, l:d:n, l:d:n, l:p:g, r:p:n, l:p:n", (GridLook)look);
            table.addHeader((Print)new TextPrint(i18n.tr("Datum"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Konto"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Gegenkonto"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Zweck"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Betrag"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Ausgef\u00fchrt"), this.fontTinyBold));
            BaseUeberweisung[] list = (BaseUeberweisung[])data;
            TextStyle typeDone = new TextStyle().font(this.fontTiny).foreground(new RGB(120, 120, 120));
            TextStyle typeOpen = new TextStyle().font(this.fontTiny).foreground(new RGB(0, 0, 0));
            BaseUeberweisung[] baseUeberweisungArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                BaseUeberweisung u = baseUeberweisungArray[n2];
                TextStyle style = u.ausgefuehrt() ? typeDone : typeOpen;
                Konto k = u.getKonto();
                String usage = VerwendungszweckUtil.toString(u, "\n");
                Date ausgefuehrt = u.getAusfuehrungsdatum();
                table.add((Print)new TextPrint(HBCI.DATEFORMAT.format(u.getTermin()), style));
                table.add((Print)new TextPrint(k.getLongName(), style));
                table.add((Print)new TextPrint(i18n.tr("{0}\nIBAN {1}, BIC {2} ({3})", new String[]{u.getGegenkontoName(), HBCIProperties.formatIban(u.getGegenkontoNummer()), u.getGegenkontoBLZ(), HBCIProperties.getNameForBank(u.getGegenkontoBLZ())}), style));
                table.add((Print)new TextPrint(usage, style));
                table.add((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(u.getBetrag())) + " " + k.getWaehrung(), style));
                if (ausgefuehrt != null) {
                    table.add((Print)new TextPrint(HBCI.DATEFORMAT.format(ausgefuehrt), style));
                } else {
                    table.add((Print)new TextPrint(i18n.tr(u.ausgefuehrt() ? "ja" : "nein"), style));
                }
                ++n2;
            }
            return table;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }

    @Override
    void customize(PagePrint page) throws ApplicationException {
        Object ctx = this.getContext();
        if (ctx instanceof TablePart) {
            ctx = ((TablePart)ctx).getSelection();
        }
        if (ctx instanceof Transfer) {
            page.setFooter(null);
        }
    }
}

