/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.EmptyPrint;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;

public class PrintSupportSepaDauerauftrag
extends AbstractPrintSupport {
    private Object ctx = null;

    public PrintSupportSepaDauerauftrag(Object ctx) {
        this.ctx = ctx;
    }

    @Override
    Print printContent() throws ApplicationException {
        Object data = this.ctx;
        if (data == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        if (data instanceof TablePart) {
            data = ((TablePart)data).getSelection();
        }
        if (!(data instanceof SepaDauerauftrag)) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Auftrag aus"));
        }
        try {
            SepaDauerauftrag a = (SepaDauerauftrag)data;
            Konto k = a.getKonto();
            DefaultGridLook look = new DefaultGridLook(5, 5);
            GridPrint table = new GridPrint("l:p:n, l:d:g", (GridLook)look);
            table.add((Print)new TextPrint(i18n.tr("Konto"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(k != null ? k.getLongName() : null), this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            String blz = a.getGegenkontoBLZ();
            table.add((Print)new TextPrint(i18n.tr("Gegenkonto"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(a.getGegenkontoName()), this.fontBold));
            table.add((Print)new EmptyPrint());
            if (blz != null && blz.length() > 0) {
                table.add((Print)new TextPrint(i18n.tr("{0} [BLZ: {1}]\nKonto: {2}", new String[]{this.notNull(HBCIProperties.getNameForBank(blz)), blz, this.notNull(a.getGegenkontoNummer())}), this.fontNormal));
            } else {
                table.add((Print)new EmptyPrint());
            }
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            String usage = VerwendungszweckUtil.toString(a, "\n");
            table.add((Print)new TextPrint(i18n.tr("Verwendungszweck"), this.fontNormal));
            table.add((Print)new TextPrint(this.notNull(usage), this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            double betrag = a.getBetrag();
            String curr = k != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE;
            table.add((Print)new TextPrint(i18n.tr("Betrag"), this.fontNormal));
            table.add((Print)new TextPrint(betrag == 0.0 || Double.isNaN(betrag) ? "-" : String.valueOf(HBCI.DECIMALFORMAT.format(betrag)) + " " + curr, this.fontBold));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            Date first = a.getErsteZahlung();
            table.add((Print)new TextPrint(i18n.tr("Erste Zahlung"), this.fontNormal));
            table.add((Print)new TextPrint(first == null ? "-" : HBCI.DATEFORMAT.format(first), this.fontNormal));
            Date last = a.getLetzteZahlung();
            table.add((Print)new TextPrint(i18n.tr("Letzte Zahlung"), this.fontNormal));
            table.add((Print)new TextPrint(last == null ? "-" : HBCI.DATEFORMAT.format(last), this.fontNormal));
            Date next = a.getNaechsteZahlung();
            table.add((Print)new TextPrint(i18n.tr("N\u00e4chste Zahlung"), this.fontNormal));
            table.add((Print)new TextPrint(next == null ? "-" : HBCI.DATEFORMAT.format(next), this.fontNormal));
            Turnus turnus = a.getTurnus();
            table.add((Print)new TextPrint(i18n.tr("Turnus"), this.fontNormal));
            table.add((Print)new TextPrint(turnus == null ? "-" : turnus.getBezeichnung(), this.fontBold));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new LineBreakPrint(this.fontNormal));
            table.add((Print)new TextPrint(i18n.tr("Aktiv"), this.fontNormal));
            table.add((Print)new TextPrint(a.isActive() ? "Ja" : "Nein", this.fontBold));
            return table;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }

    @Override
    String getTitle() throws ApplicationException {
        return i18n.tr("SEPA-Dauerauftrag");
    }
}

