/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.print;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.parts.UmsatzList;
import de.willuhn.jameica.hbci.io.print.AbstractPrintSupport;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sf.paperclips.Border;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.LineBreakPrint;
import net.sf.paperclips.NoBreakPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.TextPrint;
import net.sf.paperclips.TextStyle;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.RGB;

public class PrintSupportUmsatzList
extends AbstractPrintSupport {
    private Object ctx = null;

    public PrintSupportUmsatzList(Object ctx) {
        this.ctx = ctx;
    }

    Object getContext() {
        return this.ctx;
    }

    @Override
    Print printContent() throws ApplicationException {
        Umsatz[] data = this.getContext();
        if (data instanceof UmsatzList) {
            data = ((UmsatzList)data).getSelection();
        }
        if (data instanceof Umsatz) {
            data = new Umsatz[]{(Umsatz)data};
        }
        if (!(data instanceof Umsatz[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie mindestens einen Umsatz aus"));
        }
        try {
            Date startDate = null;
            Date endDate = null;
            Umsatz[] all = data;
            HashMap<String, List> groups = new HashMap<String, List>();
            Umsatz[] umsatzArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                Umsatz u = umsatzArray[n2];
                Date date = u.getDatum();
                if (date != null) {
                    if (startDate == null || date.before(startDate)) {
                        startDate = date;
                    }
                    if (endDate == null || date.after(endDate)) {
                        endDate = date;
                    }
                }
                Konto k = u.getKonto();
                List list = groups.computeIfAbsent(k.getID(), k1 -> new LinkedList());
                list.add(u);
                ++n2;
            }
            GridPrint grid = new GridPrint("l:d:g");
            grid.add((Print)new TextPrint(i18n.tr("Zeitraum: {0} - {1}", new String[]{HBCI.DATEFORMAT.format(startDate), HBCI.DATEFORMAT.format(endDate)}), this.fontTinyBold));
            grid.add((Print)new LineBreakPrint(this.fontTitle));
            DefaultGridLook look = new DefaultGridLook();
            look.setHeaderBackground(new RGB(220, 220, 220));
            LineBorder border = new LineBorder(new RGB(100, 100, 100));
            border.setGapSize(3);
            look.setCellBorder((Border)border);
            GridPrint table = new GridPrint("l:46pt:n, r:24pt:n, l:p:g, r:50pt:n, r:50pt:n", (GridLook)look);
            table.addHeader((Print)new TextPrint(i18n.tr("Valuta\nDatum"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint("Nr.", this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Gegenkonto/Zweck"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Betrag"), this.fontTinyBold));
            table.addHeader((Print)new TextPrint(i18n.tr("Saldo"), this.fontTinyBold));
            for (String id : groups.keySet()) {
                List umsaetze = (List)groups.get(id);
                Konto k = (Konto)Settings.getDBService().createObject(Konto.class, id);
                table.add((Print)new TextPrint(k.getLongName(), this.fontTinyBold), -1);
                for (Umsatz u : umsaetze) {
                    String usage;
                    StringBuffer sb = new StringBuffer();
                    String name = u.getGegenkontoName();
                    if (name != null && name.length() > 0) {
                        sb.append(String.valueOf(name) + "\n");
                    }
                    String kto = HBCIProperties.formatIban(u.getGegenkontoNummer());
                    String blz = u.getGegenkontoBLZ();
                    if (kto != null && kto.length() > 0 && blz != null && blz.length() > 0) {
                        String gi = HBCIProperties.getNameForBank(blz);
                        sb.append(i18n.tr("{0} - {1}", new String[]{kto, gi != null && gi.length() > 0 ? gi : blz}));
                    }
                    if ((usage = StringUtils.trimToNull((String)VerwendungszweckUtil.toString(u))) != null) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(usage);
                    }
                    TextStyle typeHaben = new TextStyle().font(this.fontTiny).foreground(new RGB(0, 0, 0));
                    TextStyle typeSoll = new TextStyle().font(this.fontTiny).foreground(new RGB(200, 0, 0));
                    table.add((Print)new TextPrint(String.valueOf(HBCI.DATEFORMAT.format(u.getValuta())) + "\n" + HBCI.DATEFORMAT.format(u.getDatum()), this.fontTiny));
                    table.add((Print)new NoBreakPrint((Print)new TextPrint(u.getID(), this.fontTiny)));
                    table.add((Print)new TextPrint(sb.toString(), this.fontTiny));
                    table.add((Print)new NoBreakPrint((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(u.getBetrag())) + " " + k.getWaehrung(), u.getBetrag() >= 0.0 ? typeHaben : typeSoll)));
                    table.add((Print)new NoBreakPrint((Print)new TextPrint(String.valueOf(HBCI.DECIMALFORMAT.format(u.getSaldo())) + " " + k.getWaehrung(), this.fontTiny)));
                }
            }
            grid.add((Print)table);
            return grid;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to print data", (Throwable)re);
            throw new ApplicationException(i18n.tr("Druck fehlgeschlagen: {0}", re.getMessage()));
        }
    }

    @Override
    String getTitle() throws ApplicationException {
        return i18n.tr("Ums\u00e4tze");
    }
}

