/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.ser;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateSerializer
extends DefaultSerializer<Date> {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private DateFormat SHORTDATEFORMAT = new SimpleDateFormat("dd.MM.yy");

    @Override
    public String serialize(Object context, Date value) throws IOException {
        return value == null ? super.serialize(context, value) : HBCI.DATEFORMAT.format(value);
    }

    @Override
    public Date unserialize(Object context, String value) throws IOException {
        block5: {
            if (value == null || value.length() == 0) {
                return null;
            }
            try {
                if (value != null && value.length() != 0) break block5;
                return null;
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse string " + value + " as date"), (Throwable)e);
                throw new IOException(i18n.tr("Text \"{0}\" ist kein g\u00fcltiges Datum", value));
            }
        }
        if (value.matches("[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{2}")) {
            return this.SHORTDATEFORMAT.parse(value);
        }
        return HBCI.DATEFORMAT.parse(value);
    }
}

