/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.ser;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.logging.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UmsatzTypSerializer
extends DefaultSerializer<UmsatzTyp> {
    private Map<String, UmsatzTyp> cache = null;

    @Override
    public String serialize(Object context, UmsatzTyp value) throws IOException {
        if (value == null) {
            return super.serialize(context, value);
        }
        return value.getName();
    }

    @Override
    public UmsatzTyp unserialize(Object context, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            UmsatzTyp t;
            if (this.cache == null) {
                this.cache = new HashMap<String, UmsatzTyp>();
                DBIterator kategorien = Settings.getDBService().createList(UmsatzTyp.class);
                while (kategorien.hasNext()) {
                    UmsatzTyp t2 = (UmsatzTyp)kategorien.next();
                    this.cache.put(t2.getName().toLowerCase(), t2);
                }
            }
            if ((t = this.cache.get(value.toLowerCase())) != null) {
                return t;
            }
            Logger.info((String)("auto-creating category " + value));
            t = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
            t.setName(value);
            t.setTyp(2);
            t.store();
            this.cache.put(value.toLowerCase(), t);
            return t;
        }
        catch (Exception e) {
            Logger.error((String)("error while auto-creating category: " + value), (Throwable)e);
            return null;
        }
    }
}

