/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.ser;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.IOException;

public class ValueSerializer
extends DefaultSerializer<Double> {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public String serialize(Object context, Double value) throws IOException {
        if (value == null) {
            return super.serialize(context, value);
        }
        return String.valueOf(HBCI.DECIMALFORMAT.format(value)) + " " + HBCIProperties.CURRENCY_DEFAULT_DE;
    }

    @Override
    public Double unserialize(Object context, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            value = value.replaceAll("[^0-9-,\\.]", "");
            if (value.length() == 0) {
                throw new Exception();
            }
            if (value.indexOf(".") != -1 && value.indexOf(",") != -1) {
                value = value.replaceAll("\\.", "");
            }
            if (value.indexOf(".") != -1) {
                value = value.replaceFirst("\\.", ",");
            }
            value = value.replaceAll("\\.", "");
            return HBCI.DECIMALFORMAT.parse(value).doubleValue();
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse string " + value + " as double"), (Throwable)e);
            throw new IOException(i18n.tr("Text \"{0}\" ist kein g\u00fcltiger Betrag", value));
        }
    }
}

