/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;

public class CheckLimitMessageConsumer
implements MessageConsumer {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        QueryMessage msg = (QueryMessage)message;
        Object o = msg.getData();
        if (!(o instanceof Transfer)) {
            Logger.warn((String)("got invalid data: " + o));
            return;
        }
        Transfer t = (Transfer)o;
        double limit = Settings.getUeberweisungLimit();
        String curr = HBCIProperties.CURRENCY_DEFAULT_DE;
        if (t instanceof HibiscusTransfer) {
            Konto k = ((HibiscusTransfer)t).getKonto();
            curr = k.getWaehrung();
        }
        if (t.getBetrag() > limit) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Auftragslimit \u00fcberschritten: {0} {1}", new String[]{HBCI.DECIMALFORMAT.format(limit), curr}), 2));
        }
    }

    public boolean autoRegister() {
        return false;
    }
}

