/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import org.apache.commons.lang.StringUtils;

public class CheckOfflineUmsatzMessageConsumer
implements MessageConsumer {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public boolean autoRegister() {
        return false;
    }

    public Class[] getExpectedMessageTypes() {
        return new Class[]{ImportMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        if (message == null || !(message instanceof ImportMessage)) {
            return;
        }
        GenericObject o = ((ImportMessage)message).getObject();
        if (!(o instanceof Umsatz)) {
            return;
        }
        Umsatz u = (Umsatz)o;
        Logger.debug((String)("imported umsatz, checking if counter entry can be created [id: " + u.getID() + "]"));
        if (u.hasFlag(2)) {
            Logger.debug((String)"skip, is not-booked entry");
            return;
        }
        Konto k = u.getKonto();
        if (k.hasFlag(2)) {
            Logger.debug((String)"skip, source account is an offline account");
            return;
        }
        Konto gegenkonto = null;
        String s = StringUtils.trimToNull((String)u.getGegenkontoNummer());
        if (s == null) {
            Logger.debug((String)"skip, have no account number for counter entry");
            return;
        }
        if (s.length() > 10) {
            Logger.debug((String)("searching for offline account with iban: " + s));
            gegenkonto = KontoUtil.findByIBAN(s, 2);
        } else {
            String blz = u.getGegenkontoBLZ();
            Logger.debug((String)("searching for offline account with kto: " + s + ", blz: " + blz));
            gegenkonto = KontoUtil.find(s, blz, 2);
        }
        if (gegenkonto == null) {
            Logger.debug((String)"skip, no matching account found");
            return;
        }
        Logger.debug((String)("found account [id: " + gegenkonto.getID() + "]"));
        SynchronizeOptions options = new SynchronizeOptions(gegenkonto);
        if (!options.getSyncOffline()) {
            Logger.debug((String)"skip, sync option disabled");
            return;
        }
        Logger.info((String)"creating counter entry");
        Umsatz gegenbuchung = (Umsatz)u.duplicate();
        gegenbuchung.setBetrag(-gegenbuchung.getBetrag());
        gegenbuchung.setKonto(gegenkonto);
        gegenbuchung.setGegenkontoNummer(k.getKontonummer());
        gegenbuchung.setGegenkontoBLZ(k.getBLZ());
        gegenbuchung.setGegenkontoName(k.getName());
        String art = i18n.tr("Auto-Buchung Offline-Konto");
        if (art.length() > 100) {
            art = art.substring(0, 100);
        }
        gegenbuchung.setArt(art);
        gegenbuchung.setSaldo(gegenkonto.getSaldo() + gegenbuchung.getBetrag());
        gegenbuchung.setUmsatzTyp(null);
        gegenbuchung.store();
        Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)gegenbuchung));
    }
}

