/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.BookmarkService;
import de.willuhn.jameica.bookmark.Context;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import java.util.List;
import javax.annotation.Resource;

public class DeleteBookmarkMessageConsumer
implements MessageConsumer {
    @Resource
    private BookmarkService service;

    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        QueryMessage msg = (QueryMessage)message;
        Object data = msg.getData();
        if (!(data instanceof HibiscusDBObject)) {
            return;
        }
        HibiscusDBObject o = (HibiscusDBObject)data;
        if (o.isNewObject()) {
            return;
        }
        String id = o.getID();
        String className = o.getClass().getName();
        List bookmarks = this.service.getBookmarks();
        int i = 0;
        while (i < bookmarks.size()) {
            String cId;
            String cClassName;
            Bookmark b = (Bookmark)bookmarks.get(i);
            Context c = b.getContext();
            if (c != null && (cClassName = c.getClassName()) != null && cClassName.equals(className) && (cId = c.getId()) != null && cId.equals(id)) {
                this.service.delete(b);
            }
            ++i;
        }
    }

    public boolean autoRegister() {
        return false;
    }
}

