/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.BaseDauerauftrag;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class MarkOverdueMessageConsumer
implements MessageConsumer {
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    private static final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    private static final Map<Class, String> types = new HashMap<Class, String>(){
        {
            this.put(AuslandsUeberweisung.class, "hibiscus.navi.transfer.uebforeign");
            this.put(SepaLastschrift.class, "hibiscus.navi.transfer.sepalast");
            this.put(SepaSammelUeberweisung.class, "hibiscus.navi.transfer.sepasammelueb");
            this.put(SepaSammelLastschrift.class, "hibiscus.navi.transfer.sepasammellast");
            this.put(SepaDauerauftrag.class, "hibiscus.navi.transfer.sepadauer");
        }
    };

    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        if (Application.inServerMode()) {
            return;
        }
        QueryMessage msg = (QueryMessage)message;
        final Map.Entry<Class, String> type = this.getType(msg.getData());
        if (type == null) {
            return;
        }
        final long currentValue = this.getCounter(type.getValue()).incrementAndGet();
        worker.schedule(new Runnable(){

            @Override
            public void run() {
                String typeId = (String)type.getValue();
                if (MarkOverdueMessageConsumer.this.getCounter(typeId).get() != currentValue) {
                    Logger.debug((String)("ignoring frequent overdue counter updates for " + typeId));
                    return;
                }
                MarkOverdueMessageConsumer.this.update((Class)type.getKey(), typeId);
            }
        }, 300L, TimeUnit.MILLISECONDS);
    }

    @PostConstruct
    private void init() {
        if (Application.inServerMode()) {
            return;
        }
        Logger.info((String)"init mark-overdue message consumer");
        worker.scheduleAtFixedRate(() -> this.updateAll(), 1L, 60L, TimeUnit.MINUTES);
    }

    private AtomicLong getCounter(String key) {
        AtomicLong result = counters.get(key);
        if (result == null) {
            result = new AtomicLong(0L);
            counters.put(key, result);
        }
        return result;
    }

    private Map.Entry<Class, String> getType(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        for (Map.Entry<Class, String> e : types.entrySet()) {
            if (!e.getKey().isAssignableFrom(type)) continue;
            return e;
        }
        return null;
    }

    void updateAll() {
        Logger.info((String)"update all unread counters");
        for (Map.Entry<Class, String> e : types.entrySet()) {
            this.update(e.getKey(), e.getValue());
        }
    }

    private void update(Class type, final String id) {
        if (type == null || id == null) {
            return;
        }
        try {
            Logger.debug((String)("updating overdue counter for " + id));
            boolean da = BaseDauerauftrag.class.isAssignableFrom(type);
            HBCIDBService service = Settings.getDBService();
            DBIterator list = service.createList(type);
            if (!da) {
                list.addFilter("(ausgefuehrt is null or ausgefuehrt = 0)");
            }
            int sum = 0;
            while (list.hasNext()) {
                Object t;
                GenericObject o = list.next();
                if (da) {
                    t = (BaseDauerauftrag)o;
                    if (t.isActive()) continue;
                    ++sum;
                    continue;
                }
                t = (Terminable)o;
                if (!t.ueberfaellig() || t.ausgefuehrt()) continue;
                ++sum;
            }
            final int result = sum;
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GUI.getNavigation().setUnreadCount(id, result);
                }
            });
        }
        catch (Exception e) {
            Logger.error((String)"unable to update number of overdue elements", (Throwable)e);
        }
    }

    public boolean autoRegister() {
        return false;
    }
}

