/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.DBPropertyUtil;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NeueUmsaetze
implements MessageConsumer {
    private static Timer timer = null;
    private static SchedulerTask task = null;
    private static DelayedListener listener = new DelayedListener(1000, (Listener)new Worker());
    private static Set<String> unread = new HashSet<String>();

    public boolean autoRegister() {
        return true;
    }

    public Class[] getExpectedMessageTypes() {
        return new Class[]{ImportMessage.class, ObjectDeletedMessage.class, SystemMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        Object msg;
        if (message instanceof SystemMessage) {
            msg = (SystemMessage)message;
            if (msg.getStatusCode() == 1) {
                NeueUmsaetze.load(false);
                timer = new Timer();
                task = new SchedulerTask();
                timer.schedule((TimerTask)task, 60000L, 60000L);
            } else if (msg.getStatusCode() == 2) {
                if (Settings.getMarkReadOnExit()) {
                    Logger.info((String)"clear unread mark for bookings");
                    unread.clear();
                }
                NeueUmsaetze.store();
            }
        }
        if (message instanceof ImportMessage) {
            GenericObject o = ((ImportMessage)message).getObject();
            if (o == null || !(o instanceof Umsatz) || o.getID() == null) {
                return;
            }
            unread.add(o.getID());
            if (Settings.getStoreUnreadFlag()) {
                listener.handleEvent(null);
            }
        }
        if (message instanceof ObjectDeletedMessage) {
            msg = (ObjectDeletedMessage)message;
            GenericObject o = ((ObjectMessage)msg).getObject();
            if (!(o instanceof Umsatz)) {
                return;
            }
            if (unread.remove(((ObjectDeletedMessage)msg).getID()) && Settings.getStoreUnreadFlag()) {
                listener.handleEvent(null);
            }
        }
    }

    public static GenericIterator<Umsatz> getNeueUmsaetze() throws RemoteException {
        if (unread.size() == 0) {
            return PseudoIterator.fromArray((GenericObject[])new Umsatz[0]);
        }
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("id in (" + StringUtils.join(unread, (String)",") + ")");
        if (list.size() == 0) {
            unread.clear();
        }
        return list;
    }

    public static void setUnread(Object umsaetze) {
        NeueUmsaetze.update(id -> unread.add((String)id), umsaetze);
    }

    public static void setRead(Object umsaetze) {
        NeueUmsaetze.update(id -> unread.remove(id), umsaetze);
    }

    private static void update(Function<String, Boolean> action, Object umsaetze) {
        try {
            if (umsaetze == null) {
                return;
            }
            try {
                List<Object> list = new ArrayList<Umsatz>();
                if (umsaetze instanceof Umsatz) {
                    list.add((Umsatz)umsaetze);
                }
                if (umsaetze instanceof List) {
                    list = (List)umsaetze;
                }
                if (umsaetze instanceof Object[]) {
                    list = Arrays.asList((Object[])umsaetze);
                }
                for (Object e : list) {
                    Umsatz u;
                    if (!(e instanceof Umsatz) || (u = (Umsatz)e).isNewObject()) continue;
                    action.apply(u.getID());
                    Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)u));
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to mark as read/unread", (Throwable)e);
            }
        }
        finally {
            NeueUmsaetze.store();
        }
    }

    public static int size() {
        return unread.size();
    }

    public static boolean isNew(Umsatz u) {
        block3: {
            try {
                if (u != null && !u.isNewObject()) break block3;
                return false;
            }
            catch (Exception e) {
                Logger.error((String)"unable to determine new state", (Throwable)e);
                return false;
            }
        }
        return unread.contains(u.getID());
    }

    public static void setAllRead() {
        if (unread.size() == 0) {
            return;
        }
        try {
            unread.clear();
            NeueUmsaetze.store();
            if (!Application.inServerMode()) {
                GUI.startView(GUI.getCurrentView().getClass(), (Object)GUI.getCurrentView().getCurrentObject());
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to refresh view", (Throwable)e);
        }
    }

    public static void reload() {
        NeueUmsaetze.load(true);
    }

    private static synchronized void store() {
        if (Settings.getStoreUnreadFlag()) {
            try {
                Logger.info((String)"store umsatz unread count");
                DBPropertyUtil.set(DBPropertyUtil.Prefix.UNREAD, "umsatz", null, "count", StringUtils.join(unread, (String)","));
                Logger.info((String)("umsatz unread count: " + unread.size()));
            }
            catch (Throwable t) {
                Logger.error((String)"unable to store umsatz unread count", (Throwable)t);
            }
        }
        NeueUmsaetze.updateUI();
    }

    private static synchronized void load(boolean reload) {
        if (Settings.getStoreUnreadFlag()) {
            Level level = reload ? Level.DEBUG : Level.INFO;
            try {
                Logger.write((Level)level, (String)"load umsatz unread count");
                String[] ids = StringUtils.split((String)DBPropertyUtil.get(DBPropertyUtil.Prefix.UNREAD, "umsatz", null, "count", ""), (String)",");
                unread.clear();
                unread.addAll(Arrays.asList(ids));
                HashSet<String> existing = new HashSet<String>();
                GenericIterator<Umsatz> fromDb = NeueUmsaetze.getNeueUmsaetze();
                while (fromDb.hasNext()) {
                    Umsatz u = (Umsatz)fromDb.next();
                    existing.add(u.getID());
                    unread.remove(u.getID());
                }
                if (unread.size() > 0) {
                    Logger.info((String)("removed unread entries that no longer exist in database: " + StringUtils.join(unread, (String)",")));
                }
                unread = existing;
                Logger.write((Level)level, (String)("umsatz unread count: " + unread.size()));
            }
            catch (Throwable t) {
                Logger.error((String)"unable to load umsatz unread count", (Throwable)t);
            }
        }
        NeueUmsaetze.updateUI();
    }

    private static void updateUI() {
        if (Application.inServerMode()) {
            return;
        }
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GUI.getNavigation().setUnreadCount("hibiscus.navi.umsatz", NeueUmsaetze.size());
            }
        });
    }

    private static class SchedulerTask
    extends TimerTask {
        private SchedulerTask() {
        }

        @Override
        public void run() {
            NeueUmsaetze.reload();
        }
    }

    private static class Worker
    implements Listener {
        private Worker() {
        }

        public void handleEvent(Event event) {
            NeueUmsaetze.store();
        }
    }
}

