/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;

public class OfflineSaldoMessageConsumer
implements MessageConsumer {
    public boolean autoRegister() {
        return false;
    }

    public Class[] getExpectedMessageTypes() {
        return new Class[]{ImportMessage.class, ObjectDeletedMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        if (message == null) {
            return;
        }
        boolean isImport = message instanceof ImportMessage;
        GenericObject o = ((ObjectMessage)message).getObject();
        if (!(o instanceof Umsatz)) {
            return;
        }
        Umsatz u = (Umsatz)o;
        Konto k = u.getKonto();
        if (k == null) {
            return;
        }
        if (!k.hasFlag(2)) {
            return;
        }
        SynchronizeOptions options = new SynchronizeOptions(k);
        if (!options.getAutoSaldo()) {
            return;
        }
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeEngine engine = (SynchronizeEngine)service.get(SynchronizeEngine.class);
        if (engine.supports(SynchronizeJobKontoauszug.class, k) && options.getSyncSaldo()) {
            return;
        }
        double betrag = u.getBetrag();
        if (Double.isNaN(betrag)) {
            return;
        }
        double saldo = k.getSaldo();
        if (Double.isNaN(saldo)) {
            saldo = 0.0;
        }
        if (isImport) {
            k.setSaldo(saldo + betrag);
        } else {
            k.setSaldo(saldo - betrag);
        }
        k.store();
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
    }
}

