/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.ReminderMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.util.Date;
import java.util.Map;

public class OrderReminderMessageConsumer
implements MessageConsumer {
    public Class[] getExpectedMessageTypes() {
        return new Class[]{ReminderMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        ReminderMessage msg = (ReminderMessage)message;
        Map data = (Map)msg.getData();
        Date termin = msg.getDate();
        MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
        HBCIDBService service = Settings.getDBService();
        Class type = loader.load((String)data.get("order.class"));
        String id = (String)data.get("order.id");
        Logger.debug((String)("checking, if order " + type.getSimpleName() + ":" + id + " has to be cloned for " + termin));
        DBIterator list = service.createList(type);
        list.addFilter("termin = ?", new Object[]{termin});
        while (list.hasNext()) {
            HibiscusDBObject t = (HibiscusDBObject)list.next();
            String from = MetaKey.REMINDER_TEMPLATE.get(t);
            if (from == null || !from.equals(id)) continue;
            Logger.debug((String)("already cloned by " + MetaKey.REMINDER_CREATOR.get(t)));
            return;
        }
        Duplicatable template = (Duplicatable)service.createObject(type, id);
        HibiscusDBObject order = (HibiscusDBObject)template.duplicate();
        String hostname = Application.getCallback().getHostname();
        try {
            order.transactionBegin();
            ((Terminable)((Object)order)).setTermin(termin);
            order.store();
            MetaKey.REMINDER_CREATOR.set(order, hostname);
            MetaKey.REMINDER_TEMPLATE.set(order, id);
            order.transactionCommit();
            Application.getMessagingFactory().sendSyncMessage((Message)new ImportMessage((GenericObject)order));
            Logger.info((String)("order " + type.getSimpleName() + ":" + id + " cloned by " + hostname + ", id: " + order.getID() + ", date: " + termin));
        }
        catch (Exception e) {
            try {
                order.transactionRollback();
            }
            catch (Exception e2) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e2);
            }
            throw e;
        }
    }

    public boolean autoRegister() {
        return false;
    }
}

