/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.hbci.forecast.ForecastCreator;
import de.willuhn.jameica.hbci.forecast.SaldoLimit;
import de.willuhn.jameica.hbci.messaging.SaldoLimitsMessage;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SaldoLimits
implements MessageConsumer {
    private static Timer timer = null;
    private static SchedulerTask task = null;
    private static DelayedListener listener = new DelayedListener(1000, (Listener)new Worker());

    public boolean autoRegister() {
        return true;
    }

    public Class[] getExpectedMessageTypes() {
        return new Class[]{SaldoMessage.class, SaldoLimitsMessage.class, SystemMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        SystemMessage msg;
        if (message instanceof SystemMessage && (msg = (SystemMessage)message).getStatusCode() == 1) {
            SaldoLimits.update();
            timer = new Timer();
            task = new SchedulerTask();
            timer.schedule((TimerTask)task, 1800000L, 1800000L);
        }
        if (message instanceof SaldoMessage || message instanceof SaldoLimitsMessage) {
            listener.handleEvent(null);
        }
    }

    private static void update() {
        ForecastCreator.updateLimits();
        for (SaldoLimit limit : ForecastCreator.getLimits()) {
            if (limit.isNotify()) continue;
        }
    }

    private static class SchedulerTask
    extends TimerTask {
        private SchedulerTask() {
        }

        @Override
        public void run() {
            SaldoLimits.update();
        }
    }

    private static class Worker
    implements Listener {
        private Worker() {
        }

        public void handleEvent(Event event) {
            SaldoLimits.update();
        }
    }
}

