/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.messaging;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.LastschriftNew;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Lastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.Date;
import java.util.Map;

public class TransferLastschriftMessageConsumer
implements MessageConsumer {
    public boolean autoRegister() {
        return false;
    }

    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        if (message == null || !(message instanceof QueryMessage)) {
            return;
        }
        Object data = ((QueryMessage)message).getData();
        if (data == null || !(data instanceof Map)) {
            Logger.warn((String)"got invalid or null message, skipping");
            return;
        }
        Lastschrift ls = null;
        try {
            Date termin;
            String type;
            Map params = (Map)data;
            HBCIDBService service = Settings.getDBService();
            ls = (Lastschrift)service.createObject(Lastschrift.class, null);
            Number betrag = (Number)params.get("value");
            if (betrag != null) {
                ls.setBetrag(betrag.doubleValue());
            }
            if ((type = (String)params.get("type")) != null) {
                ls.setTextSchluessel(type);
            }
            ls.setTermin((termin = (Date)params.get("date")) != null ? termin : new Date());
            ls.setZweck((String)params.get("usage.1"));
            ls.setZweck2((String)params.get("usage.2"));
            ls.setGegenkontoName((String)params.get("other.name"));
            ls.setGegenkontoNummer((String)params.get("other.account"));
            ls.setGegenkontoBLZ((String)params.get("other.blz"));
            String konto = (String)params.get("my.account");
            String blz = (String)params.get("my.blz");
            boolean stored = false;
            if (konto != null && blz != null) {
                DBIterator list = service.createList(Konto.class);
                list.addFilter("kontonummer = ?", new Object[]{konto});
                list.addFilter("blz = ?", new Object[]{blz});
                if (list.hasNext()) {
                    ls.setKonto((Konto)list.next());
                    ls.store();
                    stored = true;
                }
            }
            if (!stored) {
                throw new ApplicationException(Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Bitte vervollst\u00e4ndigen Sie die Angaben in Ihrer Lastschrift"));
            }
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            if (!Application.inServerMode()) {
                new LastschriftNew().handleAction(ls);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to create lastschrift", (Throwable)e);
            ((QueryMessage)message).setData((Object)e);
        }
    }
}

