/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.myema;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Date;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FibuTransfer {
    private static Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static String serverURL;
    private static String userName;
    private static String password;
    private static String bezirksID;
    private static String bookingYear;

    public static void execute(Umsatz[] umsaetze, boolean duplicateCheck) {
        serverURL = settings.getString("ServerURL", null);
        if (serverURL == null) {
            Logger.error((String)"Myema-Fehler: Umgebungsvariable <ServerURL> nicht spezifiziert");
            return;
        }
        userName = settings.getString("BenutzerName", null);
        if (userName == null) {
            Logger.error((String)"Myema-Fehler: Umgebungsvariable <BenutzerName> nicht spezifiziert");
            return;
        }
        password = settings.getString("Kennwort", null);
        if (password == null) {
            Logger.error((String)"Myema-Fehler: Umgebungsvariable <Kennwort> nicht spezifiziert");
            return;
        }
        bezirksID = settings.getString("BezirksID", null);
        if (bezirksID == null) {
            Logger.error((String)"Myema-Fehler: Umgebungsvariable <BezirksID> nicht spezifiziert");
            return;
        }
        bookingYear = settings.getString("BuchungsJahr", null);
        if (bookingYear == null) {
            Logger.error((String)"Myema-Fehler: Umgebungsvariable <BuchungsJahr> nicht spezifiziert");
            return;
        }
        Logger.info((String)"Myema-Info: Umgebungsdatei erfolgreich eingelesen");
        String myemaSessionId = FibuTransfer.login();
        if (myemaSessionId != null) {
            FibuTransfer.syncAccount(myemaSessionId, umsaetze, duplicateCheck);
            FibuTransfer.logout(myemaSessionId);
        }
    }

    private static String login() {
        String myemaSessionId = null;
        try {
            URL url = new URL(String.valueOf(serverURL) + "auth/login");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            JSONObject jo1 = new JSONObject();
            jo1.put((Object)"userName", (Object)userName);
            jo1.put((Object)"password", (Object)password);
            String bodyParams = jo1.toJSONString();
            con.setDoOutput(true);
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(bodyParams);
            osw.flush();
            osw.close();
            int statusCode = con.getResponseCode();
            if (statusCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String output = br.readLine();
                Object obj = new JSONParser().parse(output);
                JSONObject jo2 = (JSONObject)obj;
                myemaSessionId = (String)jo2.get((Object)"myemaSessionId");
                Logger.info((String)"Myema-Info: Anmeldung zum FiBu-Server erfolgreich");
            } else {
                Logger.error((String)("Myema-Fehler: Anmeldung zum FiBu-Server fehlgeschlagen - Statuscode " + statusCode));
                InputStream inpStr = con.getErrorStream();
                byte[] buff = new byte[con.getErrorStream().available()];
                int cnt = inpStr.read(buff);
                Logger.error((String)new String(buff));
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
        }
        catch (IOException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage() + " FiBu-Server nicht gestartet!?"));
        }
        catch (ParseException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
        }
        return myemaSessionId;
    }

    private static void syncAccount(String sessionId, Umsatz[] umsaetze, boolean duplicateCheck) {
        try {
            int transferCount = 0;
            int i = 0;
            while (i < umsaetze.length) {
                Umsatz u = umsaetze[i];
                String belegDatum = new Date(u.getDatum().getTime()).toString();
                if (!belegDatum.startsWith(bookingYear)) {
                    Logger.error((String)("Myema-Fehler: Belegdatum " + belegDatum + " passt nicht zum Buchungsjahr " + bookingYear));
                } else {
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"kontoNummer", (Object)u.getKonto().getKontonummer());
                    jo.put((Object)"betrag", (Object)u.getBetrag());
                    jo.put((Object)"saldo", (Object)u.getSaldo());
                    jo.put((Object)"belegDatum", (Object)belegDatum);
                    jo.put((Object)"gegenKontoName", (Object)(u.getGegenkontoName() != null ? u.getGegenkontoName() : ""));
                    jo.put((Object)"gegenKontoNummer", (Object)(u.getGegenkontoNummer() != null ? u.getGegenkontoNummer() : ""));
                    String verwendungsZweck = u.getZweck();
                    if (verwendungsZweck != null) {
                        String zweck2 = u.getZweck2();
                        if (zweck2 != null) {
                            verwendungsZweck = String.valueOf(verwendungsZweck) + zweck2;
                            String[] zweckMore = u.getWeitereVerwendungszwecke();
                            if (zweckMore.length > 0) {
                                int j = 0;
                                while (j < zweckMore.length) {
                                    verwendungsZweck = String.valueOf(verwendungsZweck) + zweckMore[j];
                                    ++j;
                                }
                            }
                        }
                    } else {
                        verwendungsZweck = "";
                    }
                    jo.put((Object)"verwendungsZweck", (Object)verwendungsZweck);
                    String bodyParams = jo.toJSONString();
                    if (FibuTransfer.sendTransferRequest(sessionId, bodyParams, duplicateCheck)) {
                        ++transferCount;
                    }
                }
                ++i;
            }
            Logger.info((String)("Myema-Info: " + transferCount + " von " + umsaetze.length + " Ums\u00e4tzen erfolgreich zur FiBu \u00fcbertragen"));
        }
        catch (RemoteException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
        }
    }

    private static boolean sendTransferRequest(String sessionId, String bodyParams, boolean duplicateCheck) {
        HttpURLConnection con;
        block6: {
            String queryParams = "?bezirksID=" + bezirksID + "&year=" + bookingYear + "&duplicateCheck=" + duplicateCheck;
            URL url = new URL(String.valueOf(serverURL) + "fibu/umsaetze" + queryParams);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("myemaSessionId", sessionId);
            con.setDoOutput(true);
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(bodyParams);
            osw.flush();
            osw.close();
            int statusCode = con.getResponseCode();
            if (statusCode == 200) break block6;
            if (statusCode == 901) {
                Logger.error((String)"Myema-Fehler: Gleich aussehender Umsatz in der Fibu-Datenbank entdeckt");
            } else {
                Logger.error((String)("Myema-Fehler: Umsatz\u00fcbertragung zum FiBu-Server fehlgeschlagen - HTTP-Fehler " + statusCode));
                InputStream inpStr = con.getErrorStream();
                byte[] buff = new byte[con.getErrorStream().available()];
                int cnt = inpStr.read(buff);
                Logger.error((String)new String(buff));
            }
            con.disconnect();
            return false;
        }
        try {
            con.disconnect();
            return true;
        }
        catch (MalformedURLException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
            return false;
        }
        catch (IOException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
            return false;
        }
    }

    private static void logout(String sessionId) {
        try {
            URL url = new URL(String.valueOf(serverURL) + "auth/logout");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("myemaSessionId", sessionId);
            int statusCode = con.getResponseCode();
            if (statusCode != 200) {
                Logger.error((String)("Myema-Fehler: Abmeldung vom FiBu-Server fehlgeschlagen - Statuscode " + statusCode));
            }
        }
        catch (MalformedURLException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage()));
        }
        catch (IOException e) {
            Logger.error((String)("Myema-Fehler: " + e.getMessage() + " FiBu-Server nicht gestartet!?"));
        }
    }
}

