/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.FileInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.SpinnerInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.AccountContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.action.PassportSync;
import de.willuhn.jameica.hbci.gui.action.PassportTest;
import de.willuhn.jameica.hbci.gui.dialogs.AccountContainerDialog;
import de.willuhn.jameica.hbci.gui.dialogs.PassportPropertyDialog;
import de.willuhn.jameica.hbci.gui.input.HBCIVersionInput;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfig;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfigFactory;
import de.willuhn.jameica.hbci.passports.ddv.Detail;
import de.willuhn.jameica.hbci.passports.ddv.KontoList;
import de.willuhn.jameica.hbci.passports.ddv.rmi.Reader;
import de.willuhn.jameica.hbci.passports.ddv.server.PassportHandleImpl;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportChipcard;

public class Controller
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private TablePart configList = null;
    private TablePart kontoList = null;
    private SelectInput pcscName = null;
    private TextInput bezeichnung = null;
    private SelectInput port = null;
    private Input ctNumber = null;
    private Input entryIndex = null;
    private FileInput ctapi = null;
    private CheckboxInput useSoftPin = null;
    private SelectInput readerPresets = null;
    private SelectInput hbciVersion = null;

    public Controller(AbstractView view) {
        super(view);
    }

    private DDVConfig getConfig() {
        Object o = this.getCurrentObject();
        if (o instanceof DDVConfig) {
            return (DDVConfig)o;
        }
        return null;
    }

    public TablePart getConfigList() throws RemoteException {
        if (this.configList != null) {
            return this.configList;
        }
        this.configList = new TablePart(DDVConfigFactory.getConfigs(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                GUI.startView(Detail.class, (Object)context);
            }
        });
        this.configList.addColumn(i18n.tr("Alias-Name"), "name");
        this.configList.addColumn(i18n.tr("Kartenleser"), "readerPreset");
        this.configList.addColumn(i18n.tr("Index des HBCI-Zugangs"), "entryIndex");
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("\u00d6ffnen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null) {
                    return;
                }
                try {
                    GUI.startView(Detail.class, (Object)context);
                }
                catch (Exception e) {
                    Logger.error((String)"error while loading config", (Throwable)e);
                    GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Anlegen der Konfiguration"));
                }
            }
        }, "document-open.png"));
        ctx.addItem(new ContextMenuItem(i18n.tr("Neue Konfiguration..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.handleCreate();
            }
        }, "document-new.png"));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("L\u00f6schen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.handleDelete((DDVConfig)context);
            }
        }, "user-trash-full.png"));
        this.configList.setContextMenu(ctx);
        this.configList.setMulti(false);
        this.configList.setRememberColWidths(true);
        this.configList.setRememberOrder(true);
        this.configList.setSummary(false);
        return this.configList;
    }

    public TablePart getKontoAuswahl() throws RemoteException {
        if (this.kontoList == null) {
            this.kontoList = new KontoList(this.getConfig());
        }
        return this.kontoList;
    }

    public SelectInput getHBCIVersion() throws RemoteException {
        if (this.hbciVersion == null) {
            this.hbciVersion = new HBCIVersionInput(null, this.getConfig().getHBCIVersion());
        }
        return this.hbciVersion;
    }

    public SelectInput getReaderPresets() {
        if (this.readerPresets != null) {
            return this.readerPresets;
        }
        Reader reader = this.getConfig().getReaderPreset();
        this.readerPresets = new SelectInput(DDVConfigFactory.getReaderPresets(), (Object)reader);
        this.readerPresets.setAttribute("name");
        this.readerPresets.setName(i18n.tr("Kartenleser"));
        this.readerPresets.setEditable(false);
        this.readerPresets.addListener((Listener)new PresetListener());
        return this.readerPresets;
    }

    private boolean isPCSC() {
        Reader r = (Reader)this.getReaderPresets().getValue();
        return r.getType().isPCSC();
    }

    public Input getCTAPI() {
        if (this.ctapi != null) {
            return this.ctapi;
        }
        this.ctapi = new FileInput(this.getConfig().getCTAPIDriver());
        this.ctapi.setName(i18n.tr("CTAPI Treiber-Datei"));
        this.ctapi.setEnabled(!this.isPCSC());
        this.ctapi.setMandatory(!this.isPCSC());
        return this.ctapi;
    }

    public SelectInput getPort() {
        if (this.port != null) {
            return this.port;
        }
        this.port = new SelectInput((Object[])DDVConfig.PORTS, (Object)this.getConfig().getPort());
        this.port.setEnabled(!this.isPCSC());
        this.port.setComment(i18n.tr("meist COM/USB"));
        this.port.setName(i18n.tr("Port des Lesers"));
        return this.port;
    }

    public Input getCTNumber() {
        if (this.ctNumber != null) {
            return this.ctNumber;
        }
        this.ctNumber = new SpinnerInput(0, 4, this.getConfig().getCTNumber());
        this.ctNumber.setEnabled(!this.isPCSC());
        this.ctNumber.setName(i18n.tr("Index des Lesers"));
        this.ctNumber.setComment(i18n.tr("meist 0"));
        return this.ctNumber;
    }

    public Input getBezeichnung() {
        if (this.bezeichnung != null) {
            return this.bezeichnung;
        }
        this.bezeichnung = new TextInput(this.getConfig().getName());
        this.bezeichnung.setComment(i18n.tr("Angabe optional"));
        this.bezeichnung.setName(i18n.tr("Alias-Name"));
        return this.bezeichnung;
    }

    public Input getPCSCName() {
        if (this.pcscName != null) {
            return this.pcscName;
        }
        ArrayList<String> available = new ArrayList<String>();
        available.add("");
        try {
            List<CardTerminal> list;
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminals terminals = terminalFactory.terminals();
            if (terminals != null && (list = terminals.list()) != null && list.size() > 0) {
                for (CardTerminal t : list) {
                    String name = StringUtils.trimToNull((String)t.getName());
                    if (name == null) continue;
                    available.add(name);
                }
            }
        }
        catch (Throwable t) {
            Logger.info((String)("unable to determine card reader list: " + t.getMessage()));
            Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)t);
        }
        this.pcscName = new SelectInput(available, (Object)this.getConfig().getPCSCName());
        this.pcscName.setEnabled(this.isPCSC());
        this.pcscName.setEditable(true);
        this.pcscName.setComment(i18n.tr("nur n\u00f6tig, wenn mehrere Leser vorhanden"));
        this.pcscName.setName(i18n.tr("Identifier des PC/SC-Kartenlesers"));
        return this.pcscName;
    }

    public Input getEntryIndex() {
        if (this.entryIndex != null) {
            return this.entryIndex;
        }
        this.entryIndex = new SpinnerInput(1, 4, this.getConfig().getEntryIndex());
        this.entryIndex.setName(i18n.tr("Index des HBCI-Zugangs"));
        this.entryIndex.setComment(i18n.tr("meist 1"));
        return this.entryIndex;
    }

    public CheckboxInput getSoftPin() {
        if (this.useSoftPin != null) {
            return this.useSoftPin;
        }
        this.useSoftPin = new CheckboxInput(this.getConfig().useSoftPin());
        this.useSoftPin.setName(i18n.tr("Tastatur des PCs zur PIN-Eingabe verwenden"));
        return this.useSoftPin;
    }

    public void handleScan() {
        try {
            String ask = i18n.tr("Legen Sie Ihre HBCI-Chipkarte vor dem Test in das Leseger\u00e4t.\nDie Suche kann einige Minuten in Anspruch nehmen. Vorgang fortsetzen?");
            if (!Application.getCallback().askUser(ask)) {
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to open confirm dialog", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Suchen des Kartenlesers: {0}", e.getMessage()), 1));
            return;
        }
        BackgroundTask task = new BackgroundTask(){
            private boolean stop = false;

            public void run(ProgressMonitor monitor) throws ApplicationException {
                final DDVConfig config = DDVConfigFactory.scan(monitor, this);
                if (Controller.this.getConfig() == null) {
                    DDVConfigFactory.store(config);
                    GUI.startView(GUI.getCurrentView().getClass(), null);
                    return;
                }
                if (config != null) {
                    GUI.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Reader reader = config.getReaderPreset();
                            Controller.this.getReaderPresets().setValue((Object)reader);
                            Controller.this.getBezeichnung().setValue((Object)config.getName());
                            Controller.this.getPCSCName().setValue((Object)config.getPCSCName());
                            Controller.this.getCTAPI().setValue((Object)config.getCTAPIDriver());
                            Controller.this.getPort().setValue((Object)config.getPort());
                            Controller.this.getCTNumber().setValue((Object)config.getCTNumber());
                            Controller.this.getEntryIndex().setValue((Object)config.getEntryIndex());
                            Controller.this.getSoftPin().setValue((Object)config.useSoftPin());
                            try {
                                Controller.this.getHBCIVersion().setValue((Object)config.getHBCIVersion());
                            }
                            catch (RemoteException re) {
                                Logger.error((String)"unable to apply hbci version", (Throwable)re);
                            }
                        }
                    });
                }
            }

            public void interrupt() {
                this.stop = true;
            }

            public boolean isInterrupted() {
                return this.stop;
            }
        };
        Application.getController().start(task);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void handleDisplayProperties() {
        HBCIPassportChipcard passport = null;
        try {
            try {
                AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
                HBCICallback callback = ((HBCI)plugin).getHBCICallback();
                if (callback != null && callback instanceof HBCICallbackSWT) {
                    ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl(this.getConfig()));
                }
                passport = DDVConfigFactory.createPassport(this.getConfig());
                new PassportPropertyDialog(1, (HBCIPassport)passport).open();
                return;
            }
            catch (OperationCanceledException oce) {
                Logger.info((String)"operation cancelled");
                if (passport == null) return;
                try {
                    passport.close();
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"error while closing passport", (Throwable)e);
                }
                return;
            }
            catch (ApplicationException e) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(e.getMessage()), 1));
                if (passport == null) return;
                try {
                    passport.close();
                    return;
                }
                catch (Exception e2) {
                    Logger.error((String)"error while closing passport", (Throwable)e2);
                }
                return;
            }
            catch (Throwable t) {
                Logger.error((String)"error while displaying BPD/UPD", (Throwable)t);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler Anzeigen der BPD/UPD"), 1));
                if (passport == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    passport.close();
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"error while closing passport", (Throwable)e);
                }
                return;
            }
        }
        finally {
            if (passport != null) {
                try {
                    passport.close();
                }
                catch (Exception e) {
                    Logger.error((String)"error while closing passport", (Throwable)e);
                }
            }
        }
    }

    public void handleCreate() {
        GUI.startView(Detail.class, (Object)DDVConfigFactory.create());
    }

    public void handleDelete(DDVConfig config) {
        if (config == null) {
            return;
        }
        try {
            if (!Application.getCallback().askUser(i18n.tr("Wollen Sie diese Konfiguration wirklich l\u00f6schen?"))) {
                return;
            }
            DDVConfigFactory.delete(config);
            this.getConfigList().removeItem((Object)config);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Konfiguration gel\u00f6scht"), 0));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            GUI.getStatusBar().setErrorText(i18n.tr(ae.getMessage()));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"error while deleting config", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim L\u00f6schen der Konfiguration: {0}", e.getMessage()), 1));
        }
    }

    public synchronized void handleSync() {
        try {
            if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher?"))) {
                return;
            }
            new PassportSync().handleAction(new PassportHandleImpl(this.getConfig()));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Synchronisieren des Bank-Zugangs: {0}", e.getMessage()), 1));
        }
    }

    public boolean handleStore() {
        try {
            if (!this.isPCSC()) {
                this.getConfig().setCTNumber((Integer)this.getCTNumber().getValue());
                this.getConfig().setPort((String)this.getPort().getValue());
                this.getConfig().setCTAPIDriver((String)this.getCTAPI().getValue());
            } else {
                this.getConfig().setPCSCName((String)this.getPCSCName().getValue());
            }
            this.getConfig().setEntryIndex((Integer)this.getEntryIndex().getValue());
            this.getConfig().setSoftPin((Boolean)this.getSoftPin().getValue());
            this.getConfig().setKonten(this.getKontoAuswahl().getItems());
            this.getConfig().setReaderPreset((Reader)this.getReaderPresets().getValue());
            this.getConfig().setHBCIVersion((String)this.getHBCIVersion().getValue());
            this.getConfig().setName((String)this.getBezeichnung().getValue());
            DDVConfigFactory.store(this.getConfig());
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Einstellungen gespeichert"), 0));
            return true;
        }
        catch (Exception e) {
            Logger.error((String)"error while storing ddv config", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Speichern der Einstellungen: {0}", e.getMessage()), 1));
            return false;
        }
    }

    public void handleTest() {
        if (!this.handleStore()) {
            return;
        }
        try {
            new PassportTest().handleAction(new PassportHandleImpl(this.getConfig()));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Testen der Konfiguration: {0}", e.getMessage()), 1));
        }
    }

    public void handleChangeBankData() {
        if (!this.handleStore()) {
            return;
        }
        Application.getController().start(new BackgroundTask(){

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(ProgressMonitor monitor) throws ApplicationException {
                HBCIPassportChipcard passport = null;
                try {
                    try {
                        AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
                        HBCICallback callback = ((HBCI)plugin).getHBCICallback();
                        if (callback != null && callback instanceof HBCICallbackSWT) {
                            ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl(Controller.this.getConfig()));
                        }
                        passport = DDVConfigFactory.createPassport(Controller.this.getConfig());
                        AccountContainerDialog d = new AccountContainerDialog((HBCIPassport)passport);
                        AccountContainer container = (AccountContainer)d.open();
                        passport.setBLZ(container.blz);
                        passport.setUserId(container.userid);
                        passport.setCustomerId(container.customerid);
                        passport.setHost(container.host);
                        passport.setFilterType(container.filter);
                        passport.setCountry(container.country);
                        passport.saveChanges();
                        passport.saveBankData();
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bankdaten gespeichert"), 0));
                        return;
                    }
                    catch (ApplicationException ae) {
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                        if (passport == null) return;
                        try {
                            Logger.info((String)"closing passport");
                            passport.close();
                            return;
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to close passport", (Throwable)e);
                        }
                        return;
                    }
                    catch (OperationCanceledException oce) {
                        Logger.info((String)"operation cancelled");
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Vorgang abgebrochen"), 1));
                        if (passport == null) return;
                        try {
                            Logger.info((String)"closing passport");
                            passport.close();
                            return;
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to close passport", (Throwable)e);
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (HBCIProperties.getCause(e, OperationCanceledException.class) != null) {
                            Logger.info((String)"operation cancelled");
                            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Vorgang abgebrochen"), 1));
                        } else {
                            Logger.error((String)"error while changing bank data", (Throwable)e);
                            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00c4ndern der Bankdaten: {0}", e.getMessage()), 1));
                        }
                        if (passport == null) return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            Logger.info((String)"closing passport");
                            passport.close();
                            return;
                        }
                        catch (Exception e2) {
                            Logger.error((String)"unable to close passport", (Throwable)e2);
                        }
                        return;
                    }
                }
                finally {
                    if (passport != null) {
                        try {
                            Logger.info((String)"closing passport");
                            passport.close();
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to close passport", (Throwable)e);
                        }
                    }
                }
            }

            public boolean isInterrupted() {
                return false;
            }

            public void interrupt() {
            }
        });
    }

    private class PresetListener
    implements Listener {
        private PresetListener() {
        }

        public void handleEvent(Event event) {
            try {
                Reader r = (Reader)Controller.this.getReaderPresets().getValue();
                if (r == null) {
                    return;
                }
                if (!r.isSupported()) {
                    GUI.getView().setErrorText(i18n.tr("Der ausgew\u00e4hlte Kartenleser wird von Hibiscus nicht unterst\u00fctzt"));
                    return;
                }
                boolean pcsc = Controller.this.isPCSC();
                Controller.this.getCTAPI().setEnabled(!pcsc);
                Controller.this.getCTNumber().setEnabled(!pcsc);
                Controller.this.getPort().setEnabled(!pcsc);
                Controller.this.getPCSCName().setEnabled(pcsc);
                if (!pcsc) {
                    int ctNumber;
                    String port;
                    File f;
                    String s = r.getCTAPIDriver();
                    if (s != null && s.length() > 0 && !(f = new File(s)).exists()) {
                        GUI.getView().setErrorText(i18n.tr("CTAPI-Treiber nicht gefunden. Bitte Treiber installieren."));
                    }
                    if ((port = r.getPort()) != null) {
                        Controller.this.getPort().setPreselected((Object)port);
                    }
                    if ((ctNumber = r.getCTNumber()) >= 0) {
                        Controller.this.getCTNumber().setValue((Object)ctNumber);
                    }
                    Controller.this.getCTAPI().setValue((Object)s);
                } else {
                    Controller.this.getCTAPI().setValue((Object)"");
                }
                Controller.this.getSoftPin().setValue((Object)r.useSoftPin());
            }
            catch (Exception e) {
                Logger.error((String)"error while applying reader preset", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der Einstellungen: {0}", e.getMessage()), 1));
            }
        }
    }
}

