/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv;

import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passport.Configuration;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfigFactory;
import de.willuhn.jameica.hbci.passports.ddv.Detail;
import de.willuhn.jameica.hbci.passports.ddv.rmi.Reader;
import de.willuhn.jameica.hbci.passports.ddv.server.CustomReader;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DDVConfig
implements Configuration {
    public static final String[] PORTS = new String[]{"COM/USB", "COM2/USB2", "USB3", "USB4", "USB5", "USB6"};
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(DDVConfig.class);
    private String id = null;

    DDVConfig(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.getReaderPreset().getName()) + " (" + this.getName() + ")";
    }

    @Override
    public Class getConfigDialog() throws RemoteException {
        return Detail.class;
    }

    private String getPrefix() {
        return "config." + this.getId() + ".";
    }

    public String getName() {
        return settings.getString(String.valueOf(this.getPrefix()) + "name", "default");
    }

    public void setName(String name) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "name", name);
    }

    public String getPort() {
        return settings.getString(String.valueOf(this.getPrefix()) + "port", PORTS[0]);
    }

    public void setPort(String port) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "port", port);
    }

    public int getCTNumber() {
        return settings.getInt(String.valueOf(this.getPrefix()) + "ctnumber", 0);
    }

    public void setCTNumber(int ctNumber) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "ctnumber", ctNumber);
    }

    public boolean useSoftPin() {
        return settings.getBoolean(String.valueOf(this.getPrefix()) + "softpin", false);
    }

    public void setSoftPin(boolean softPin) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "softpin", softPin);
    }

    public String getPCSCName() {
        return settings.getString(String.valueOf(this.getPrefix()) + "pcscname", null);
    }

    public void setPCSCName(String javaname) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "pcscname", javaname);
    }

    public int getEntryIndex() {
        return settings.getInt(String.valueOf(this.getPrefix()) + "entryidx", 1);
    }

    public void setEntryIndex(int index) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "entryidx", index);
    }

    public String getCTAPIDriver() {
        return settings.getString(String.valueOf(this.getPrefix()) + "ctapi", "");
    }

    public void setCTAPIDriver(String file) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "ctapi", file);
    }

    public Reader getReaderPreset() {
        String s = settings.getString(String.valueOf(this.getPrefix()) + "readerpreset", CustomReader.class.getName());
        try {
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class<?> c = Class.forName(s);
            return (Reader)service.get(c);
        }
        catch (Throwable t) {
            Logger.error((String)"error while reading presets - you can ignore this error message", (Throwable)t);
            return new CustomReader();
        }
    }

    public void setReaderPreset(Reader reader) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "readerpreset", reader != null ? reader.getClass().getName() : null);
    }

    public String getHBCIVersion() {
        return settings.getString(String.valueOf(this.getPrefix()) + "hbciversion", settings.getString("hbciversion", this.getReaderPreset().getDefaultHBCIVersion()));
    }

    public void setHBCIVersion(String version) {
        settings.setAttribute(String.valueOf(this.getPrefix()) + "hbciversion", version);
    }

    public List<Konto> getKonten() throws RemoteException {
        String[] ids = settings.getList(String.valueOf(this.getPrefix()) + "konto", null);
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<String> fixedIds = new ArrayList<String>();
        ArrayList<Konto> konten = new ArrayList<Konto>();
        int i = 0;
        while (i < ids.length) {
            try {
                konten.add((Konto)Settings.getDBService().createObject(Konto.class, ids[i]));
                fixedIds.add(ids[i]);
            }
            catch (ObjectNotFoundException noe) {
                Logger.warn((String)("account " + ids[i] + " does not exist, removing from list"));
            }
            ++i;
        }
        if (fixedIds.size() != ids.length) {
            Logger.info((String)"fixing list of assigned accounts");
            settings.setAttribute(String.valueOf(this.getPrefix()) + "konto", fixedIds.toArray(new String[0]));
        }
        return konten;
    }

    public void setKonten(List<Konto> list) throws RemoteException {
        if (list == null || list.size() == 0) {
            settings.setAttribute(String.valueOf(this.getPrefix()) + "konto", null);
            return;
        }
        String[] ids = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            ids[i] = list.get(i).getID();
            ++i;
        }
        settings.setAttribute(String.valueOf(this.getPrefix()) + "konto", ids);
    }

    public static int getPortForName(String name) throws RemoteException {
        if (name == null || name.length() == 0) {
            return 0;
        }
        int i = 0;
        while (i < PORTS.length) {
            if (PORTS[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public DDVConfig copy() {
        DDVConfig copy = DDVConfigFactory.create();
        copy.setCTAPIDriver(this.getCTAPIDriver());
        copy.setCTNumber(this.getCTNumber());
        copy.setEntryIndex(this.getEntryIndex());
        copy.setHBCIVersion(this.getHBCIVersion());
        copy.setName(this.getName());
        copy.setPort(this.getPort());
        copy.setReaderPreset(this.getReaderPreset());
        copy.setSoftPin(this.useSoftPin());
        copy.setPCSCName(this.getPCSCName());
        return copy;
    }

    void deleteProperties() {
        this.setCTAPIDriver(null);
        this.setHBCIVersion(null);
        this.setName(null);
        this.setPort(null);
        this.setReaderPreset(null);
        settings.setAttribute(String.valueOf(this.getPrefix()) + "softpin", null);
        settings.setAttribute(String.valueOf(this.getPrefix()) + "ctnumber", null);
        settings.setAttribute(String.valueOf(this.getPrefix()) + "entryidx", null);
        settings.setAttribute(String.valueOf(this.getPrefix()) + "javaname", null);
        settings.setAttribute(String.valueOf(this.getPrefix()) + "konto", null);
    }

    @Override
    public void delete() throws ApplicationException {
        DDVConfigFactory.delete(this);
    }
}

