/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfig;
import de.willuhn.jameica.hbci.passports.ddv.PassportParameter;
import de.willuhn.jameica.hbci.passports.ddv.SelectConfigDialog;
import de.willuhn.jameica.hbci.passports.ddv.rmi.Reader;
import de.willuhn.jameica.hbci.passports.ddv.server.CustomReader;
import de.willuhn.jameica.hbci.passports.ddv.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ClassFinder;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassportChipcard;

public class DDVConfigFactory {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(DDVConfigFactory.class);
    private static List<Reader> presets = null;

    public static List<DDVConfig> getConfigs() {
        String[] ids = settings.getList("config", new String[0]);
        ArrayList<DDVConfig> configs = new ArrayList<DDVConfig>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            configs.add(new DDVConfig(id));
            ++n2;
        }
        return configs;
    }

    public static synchronized List<Reader> getReaderPresets() {
        if (presets != null) {
            return presets;
        }
        presets = new ArrayList<Reader>();
        try {
            Class[] found;
            Logger.info((String)"searching for reader presets");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ClassFinder finder = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder();
            Class[] classArray = found = finder.findImplementors(Reader.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class r = classArray[n2];
                try {
                    presets.add((Reader)service.get(r));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load reader preset " + r + " - skipping"), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error((String)"no reader presets found");
            presets.add(new CustomReader());
        }
        Collections.sort(presets, new Comparator<Reader>(){

            @Override
            public int compare(Reader r1, Reader r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        return presets;
    }

    public static void store(DDVConfig config) {
        if (config == null) {
            return;
        }
        String[] ids = settings.getList("config", new String[0]);
        ArrayList<String> newIds = new ArrayList<String>();
        boolean found = false;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id != null && id.length() != 0) {
                found |= id.equals(config.getId());
                newIds.add(id);
            }
            ++n2;
        }
        if (!found) {
            newIds.add(config.getId());
        }
        settings.setAttribute("config", newIds.toArray(new String[0]));
    }

    public static void delete(DDVConfig config) throws ApplicationException {
        if (config == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu l\u00f6schende Konfiguration aus"));
        }
        config.deleteProperties();
        String[] ids = settings.getList("config", new String[0]);
        ArrayList<String> newIds = new ArrayList<String>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id != null && id.length() != 0 && !id.equals(config.getId())) {
                newIds.add(id);
            }
            ++n2;
        }
        settings.setAttribute("config", newIds.toArray(new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DDVConfig scan(ProgressMonitor monitor, BackgroundTask task) {
        DDVConfig temp = new DDVConfig("__scan__");
        try {
            List<Reader> list = DDVConfigFactory.getReaderPresets();
            int factor = 100 / (list.size() * DDVConfig.PORTS.length);
            for (Reader reader : list) {
                int ctNumber;
                if (task.isInterrupted()) {
                    throw new OperationCanceledException();
                }
                monitor.setStatusText(i18n.tr("Teste {0}", reader.getName()));
                if (!reader.isSupported()) {
                    monitor.log("  " + i18n.tr("\u00fcberspringe Kartenleser, wird von Ihrem System nicht unterst\u00fctzt"));
                    continue;
                }
                String s = StringUtils.trimToNull((String)reader.getCTAPIDriver());
                Reader.Type type = reader.getType();
                if (type.isCTAPI()) {
                    if (s == null) {
                        monitor.log("  " + i18n.tr("\u00fcberspringe Kartenleser, kein CTAPI-Treiber definiert."));
                        continue;
                    }
                    File f = new File(s);
                    if (!f.exists()) {
                        monitor.log("  " + i18n.tr("\u00fcberspringe Kartenleser, CTAPI-Treiber {0} existiert nicht.", f.getAbsolutePath()));
                        continue;
                    }
                }
                temp.setCTNumber((ctNumber = reader.getCTNumber()) == -1 ? 0 : ctNumber);
                temp.setEntryIndex(1);
                temp.setReaderPreset(reader);
                temp.setSoftPin(reader.useSoftPin());
                temp.setCTAPIDriver(s);
                temp.setHBCIVersion(reader.getDefaultHBCIVersion());
                if (type.isPCSC()) {
                    try {
                        CardTerminals terminals = TerminalFactory.getDefault().terminals();
                        if (terminals == null) {
                        }
                        List<CardTerminal> l = terminals.list();
                        if (l == null) {
                        }
                        if (l.size() <= 0) {
                        }
                        CardTerminal terminal = l.get(0);
                        String name = terminal.getName();
                        temp.setPCSCName(name);
                        if (DDVConfigFactory.testConfig(monitor, temp)) {
                            DDVConfig config = temp.copy();
                            config.setName(name);
                            DDVConfig dDVConfig = config;
                            return dDVConfig;
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to create ddv config", (Throwable)e);
                        continue;
                    }
                    finally {
                        temp.setPCSCName(null);
                    }
                }
                String[] stringArray = DDVConfig.PORTS;
                int n = DDVConfig.PORTS.length;
                int n2 = 0;
                while (n2 < n) {
                    String port = stringArray[n2];
                    if (task.isInterrupted()) {
                        throw new OperationCanceledException();
                    }
                    monitor.addPercentComplete(factor);
                    monitor.log("  " + i18n.tr("Port {0}", port));
                    temp.setPort(port);
                    if (DDVConfigFactory.testConfig(monitor, temp)) {
                        DDVConfig config = temp.copy();
                        config.setName(i18n.tr("Neue Kartenleser-Konfiguration"));
                        DDVConfig dDVConfig = config;
                        return dDVConfig;
                    }
                    ++n2;
                }
            }
            monitor.setStatusText(i18n.tr("Kein Kartenleser gefunden. Bitte manuell konfigurieren"));
            monitor.setStatus(3);
            monitor.setPercentComplete(100);
            return null;
        }
        catch (OperationCanceledException oce) {
            monitor.setStatus(5);
            monitor.setStatusText(i18n.tr("Abgebrochen"));
            monitor.setPercentComplete(100);
            return null;
        }
        finally {
            try {
                temp.delete();
            }
            catch (Exception e) {
                Logger.error((String)"unable to delete temp-config", (Throwable)e);
            }
        }
    }

    private static boolean testConfig(ProgressMonitor monitor, DDVConfig config) {
        PassportHandleImpl handle = null;
        try {
            handle = new PassportHandleImpl(config);
            handle.open();
            handle.close();
            handle = null;
            monitor.log("  " + i18n.tr("gefunden"));
            monitor.setStatusText(i18n.tr("OK. Kartenleser gefunden"));
            monitor.setStatus(4);
            monitor.setPercentComplete(100);
            return true;
        }
        catch (ApplicationException ae) {
            monitor.log("  " + ae.getMessage());
        }
        catch (Exception e) {
            monitor.log("  " + i18n.tr("  nicht gefunden"));
            Logger.info((String)("exception: " + e.getMessage()));
            Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)e);
        }
        finally {
            if (handle != null) {
                try {
                    handle.close();
                }
                catch (Throwable t) {
                    Logger.error((String)"closing of passport handle failed", (Throwable)t);
                }
            }
        }
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static synchronized DDVConfig findByKonto(Konto konto) throws RemoteException, ApplicationException {
        List<DDVConfig> list = DDVConfigFactory.getConfigs();
        if (list.size() == 0) {
            throw new ApplicationException(i18n.tr("Bitte legen Sie zuerst eine Kartenleser-Konfiguration an"));
        }
        Logger.info((String)("searching config for konto " + konto.getKontonummer() + ", blz: " + konto.getBLZ()));
        for (DDVConfig c : list) {
            List<Konto> verdrahtet = c.getKonten();
            if (konto == null || verdrahtet == null || verdrahtet.size() <= 0) continue;
            for (Konto k : verdrahtet) {
                if (!konto.equals((GenericObject)k)) continue;
                Logger.info((String)("found config via account. name: " + c.getName()));
                return c;
            }
        }
        if (list.size() == 1) {
            DDVConfig config = list.get(0);
            Logger.info((String)("using config : " + config.getName()));
            return config;
        }
        SelectConfigDialog d = new SelectConfigDialog(1);
        try {
            return (DDVConfig)d.open();
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"error while choosing config", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Auswahl der Kartenleser-Konfiguration: {0}", e.getMessage()));
        }
    }

    public static DDVConfig create() {
        return new DDVConfig(UUID.randomUUID().toString());
    }

    public static HBCIPassportChipcard createPassport(DDVConfig config) throws ApplicationException, RemoteException {
        File f;
        if (config == null) {
            throw new ApplicationException(i18n.tr("Keine Konfiguration ausgew\u00e4hlt"));
        }
        Reader.Type type = config.getReaderPreset().getType();
        if (type.isPCSC()) {
            String pcscName = config.getPCSCName();
            Logger.info((String)("  pcsc name: " + pcscName));
            if (StringUtils.trimToNull((String)pcscName) != null) {
                HBCIUtils.setParam((String)PassportParameter.get(type, "pcsc.name"), (String)pcscName);
            }
        } else {
            String jni = DDVConfigFactory.getJNILib().getAbsolutePath();
            Logger.info((String)("  jni lib: " + jni));
            HBCIUtils.setParam((String)"client.passport.DDV.libname.ddv", (String)jni);
            String ctapiDriver = config.getCTAPIDriver();
            if (ctapiDriver == null || ctapiDriver.length() == 0) {
                throw new ApplicationException(i18n.tr("Kein CTAPI-Treiber in der Kartenleser-Konfiguration angegeben"));
            }
            File ctapi = new File(ctapiDriver);
            if (!(ctapi.exists() && ctapi.isFile() && ctapi.canRead())) {
                throw new ApplicationException(i18n.tr("CTAPI-Treiber-Datei \"{0}\" nicht gefunden oder nicht lesbar", ctapiDriver));
            }
            Logger.info((String)("  ctapi driver: " + ctapiDriver));
            HBCIUtils.setParam((String)PassportParameter.get(type, "libname.ctapi"), (String)ctapiDriver);
        }
        if (!(f = new File(String.valueOf(Settings.getWorkPath()) + "/passports/")).exists()) {
            f.mkdirs();
        }
        String headerName = type == Reader.Type.RDH_PCSC ? "RSA" : "DDV";
        HBCIUtils.setParam((String)("client.passport." + headerName + ".path"), (String)(String.valueOf(Settings.getWorkPath()) + "/passports/"));
        if (type.isCTAPI()) {
            String port = Integer.toString(DDVConfig.getPortForName(config.getPort()));
            Logger.info((String)("  port: " + config.getPort() + " [ID: " + port + "]"));
            HBCIUtils.setParam((String)PassportParameter.get(type, "port"), (String)port);
            Logger.info((String)("  ctnumber: " + config.getCTNumber()));
            HBCIUtils.setParam((String)PassportParameter.get(type, "ctnumber"), (String)Integer.toString(config.getCTNumber()));
        }
        Logger.info((String)("  soft pin: " + config.useSoftPin()));
        HBCIUtils.setParam((String)PassportParameter.get(type, "softpin"), (String)(config.useSoftPin() ? "1" : "0"));
        Logger.info((String)("  entry index: " + config.getEntryIndex()));
        HBCIUtils.setParam((String)PassportParameter.get(type, "entryidx"), (String)Integer.toString(config.getEntryIndex()));
        Logger.info((String)("  hbci version: " + config.getHBCIVersion()));
        String id = type.getIdentifier();
        Logger.info((String)("  passport type: " + id));
        HBCIPassportChipcard passport = (HBCIPassportChipcard)AbstractHBCIPassport.getInstance((String)id);
        Logger.info((String)("  host: " + passport.getHost()));
        Logger.info((String)("  blz: " + passport.getBLZ()));
        return passport;
    }

    private static File getJNILib() throws ApplicationException {
        String file = null;
        switch (Application.getPlatform().getOS()) {
            case 1: {
                file = "libhbci4java-card-linux-32.so";
                break;
            }
            case 4: {
                file = "libhbci4java-card-linux-64.so";
                break;
            }
            case 2: {
                file = "hbci4java-card-win32.dll";
                break;
            }
            case 5: {
                file = "hbci4java-card-win32_x86-64.dll";
                break;
            }
            case 3: {
                String arch = System.getProperty("os.arch");
                if (arch != null && arch.contains("64")) {
                    file = "libhbci4java-card-mac-os-x-10.6.jnilib";
                    break;
                }
                file = "libhbci4java-card-mac.jnilib";
                break;
            }
            case 7: {
                file = "libhbci4java-card-freebsd-64.so";
            }
        }
        if (file == null) {
            throw new ApplicationException(i18n.tr("Hibiscus unterst\u00fctzt leider keine Chipkartenleser f\u00fcr Ihr Betriebssystem"));
        }
        File f = new File(Settings.getLibPath(), file);
        if (!f.exists()) {
            throw new ApplicationException(i18n.tr("Treiber {0} nicht gefunden", f.getAbsolutePath()));
        }
        if (!f.isFile() || !f.canRead()) {
            throw new ApplicationException(i18n.tr("Treiber {0} nicht lesbar", f.getAbsolutePath()));
        }
        return f;
    }
}

