/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.LabelGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfig;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfigFactory;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class SelectConfigDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private DDVConfig selected = null;
    private String text = null;

    public SelectConfigDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Auswahl der Kartenleser-Konfiguration"));
    }

    protected void paint(Composite parent) throws Exception {
        LabelGroup group = new LabelGroup(parent, i18n.tr("Konfiguration"));
        group.addText(this.text == null ? i18n.tr("Bitte w\u00e4hlen Sie die zu verwendende Kartenleser-Konfiguration aus") : this.text, true);
        final TablePart table = new TablePart(DDVConfigFactory.getConfigs(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof DDVConfig)) {
                    return;
                }
                SelectConfigDialog.this.selected = (DDVConfig)context;
                SelectConfigDialog.this.close();
            }
        });
        table.addColumn(i18n.tr("Alias-Name"), "name");
        table.addColumn(i18n.tr("Kartenleser"), "readerPreset");
        table.addColumn(i18n.tr("Index des HBCI-Zugangs"), "entryIndex");
        table.setMulti(false);
        table.setSummary(false);
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SelectConfigDialog.this.selected = (DDVConfig)table.getSelection();
                if (SelectConfigDialog.this.selected == null) {
                    return;
                }
                SelectConfigDialog.this.close();
            }
        }, null, true);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        });
        buttons.paint(parent);
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Object getData() throws Exception {
        return this.selected;
    }
}

