/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv.server;

import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passports.ddv.rmi.Reader;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import java.io.IOException;
import org.kapott.hbci.manager.HBCIVersion;

public abstract class AbstractReader
implements Reader {
    File getCTAPIDriverPath() {
        File f = new File(Settings.getLibPath());
        switch (Application.getPlatform().getOS()) {
            case 1: {
                try {
                    return f.getCanonicalFile();
                }
                catch (IOException e) {
                    Logger.error((String)"error while converting ctapi path into canonical path", (Throwable)e);
                    return f;
                }
            }
            case 2: {
                try {
                    f = new File("C:/Windows/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                    f = new File("C:/WinNT/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                    f = new File("C:/Win2000/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                    f = new File("C:/WinXP/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                    f = new File("C:/Win/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return f;
            }
            case 5: {
                try {
                    f = new File("C:/Windows/SysWOW64");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                    f = new File("C:/Windows/System32");
                    if (f.isDirectory() && f.exists()) {
                        return f;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return f;
            }
            case 3: {
                return f;
            }
        }
        return f;
    }

    @Override
    public String getPort() {
        return "COM2/USB2";
    }

    @Override
    public int getCTNumber() {
        return 0;
    }

    @Override
    public boolean useSoftPin() {
        return false;
    }

    @Override
    public Reader.Type getType() {
        return Reader.Type.DDV_CTAPI;
    }

    @Override
    public String getDefaultHBCIVersion() {
        return HBCIVersion.HBCI_300.getId();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reader)) {
            return false;
        }
        Reader other = (Reader)obj;
        String s1 = String.valueOf(this.getClass().getName()) + this.getName() + this.getCTAPIDriver();
        String s2 = String.valueOf(other.getClass().getName()) + other.getName() + other.getCTAPIDriver();
        return s1.equals(s2);
    }
}

