/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfig;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfigFactory;
import de.willuhn.jameica.hbci.passports.ddv.SelectConfigDialog;
import de.willuhn.jameica.hbci.passports.ddv.server.PassportImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportHandleImpl
extends UnicastRemoteObject
implements PassportHandle {
    private static final Settings settings = new Settings(DDVConfig.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HBCIPassport hbciPassport = null;
    private HBCIHandler handler = null;
    private Konto konto = null;
    private DDVConfig config = null;

    public PassportHandleImpl(Konto konto) throws RemoteException {
        this.konto = konto;
    }

    public PassportHandleImpl(DDVConfig config) throws RemoteException {
        this.config = config;
    }

    @Override
    public HBCIHandler open() throws RemoteException, ApplicationException {
        if (this.isOpen()) {
            return this.handler;
        }
        Logger.info((String)"open ddv passport");
        try {
            if (this.config == null && this.konto != null) {
                this.config = DDVConfigFactory.findByKonto(this.konto);
            }
            if (this.config == null) {
                List<DDVConfig> list = DDVConfigFactory.getConfigs();
                if (list == null || list.size() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte legen Sie zuerst eine Kartenleser-Konfiguration an"));
                }
                if (list.size() == 1) {
                    this.config = list.get(0);
                } else {
                    SelectConfigDialog d = new SelectConfigDialog(1);
                    try {
                        this.config = (DDVConfig)d.open();
                    }
                    catch (OperationCanceledException oce) {
                        throw oce;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while choosing config", (Throwable)e);
                        throw new ApplicationException(i18n.tr("Fehler bei der Auswahl der PIN/TAN-Konfiguration"));
                    }
                }
            }
            if (this.config == null) {
                throw new ApplicationException(i18n.tr("Keine Kartenleser-Konfiguration vorhanden"));
            }
            Logger.debug((String)("using config " + this.config.getName()));
            AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
            HBCICallback callback = ((HBCI)plugin).getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(this);
            }
            this.hbciPassport = DDVConfigFactory.createPassport(this.config);
            ((AbstractHBCIPassport)this.hbciPassport).setPersistentData("hibiscus.context.config", (Object)this.config);
            Logger.info((String)"ddv passport opened");
            Logger.info((String)("  hbci version: " + this.config.getHBCIVersion()));
            this.handler = new HBCIHandler(this.config.getHBCIVersion(), this.hbciPassport);
            Logger.info((String)"ddv handler opened");
            return this.handler;
        }
        catch (OperationCanceledException | ApplicationException | RemoteException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new RemoteException("error while opening chipcard", e);
        }
    }

    @Override
    public boolean isOpen() throws RemoteException {
        return this.handler != null && this.hbciPassport != null;
    }

    @Override
    public void close() throws RemoteException {
        if (this.hbciPassport == null && this.handler == null) {
            return;
        }
        try {
            Logger.info((String)"closing ddv passport");
            this.handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hbciPassport = null;
        this.handler = null;
        AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        HBCICallback callback = ((HBCI)plugin).getHBCICallback();
        if (callback != null && callback instanceof HBCICallbackSWT) {
            ((HBCICallbackSWT)callback).setCurrentHandle(null);
        }
        Logger.info((String)"ddv passport closed");
    }

    @Override
    public Konto[] getKonten() throws RemoteException, ApplicationException {
        Logger.info((String)"reading accounts from ddv passport");
        this.open();
        org.kapott.hbci.structures.Konto[] konten = this.hbciPassport.getAccounts();
        if (konten == null || konten.length == 0) {
            Logger.info((String)"no accounts found");
            Konto[] kontoArray = new Konto[]{};
            return kontoArray;
        }
        ArrayList<Konto> result = new ArrayList<Konto>();
        Konto k = null;
        int i = 0;
        while (i < konten.length) {
            k = Converter.HBCIKonto2HibiscusKonto(konten[i], PassportImpl.class);
            Logger.debug((String)("found account " + k.getKontonummer()));
            result.add(k);
            ++i;
        }
        Konto[] kontoArray = result.toArray(new Konto[0]);
        return kontoArray;
        finally {
            try {
                this.close();
            }
            catch (RemoteException remoteException) {}
        }
    }

    @Override
    public boolean callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) throws Exception {
        switch (reason) {
            case 4: {
                retData.replace(0, retData.length(), DialogFactory.getPIN(passport));
                return true;
            }
            case 2: {
                return this.handleCallback(i18n.tr("Bitte legen Sie die Chipkarte in das Leseger\u00e4t"), true, settings.getBoolean("waitfor.card.insert", false), 2);
            }
            case 6: {
                return this.handleCallback(i18n.tr("HBCI-Chipkarte wird ausgelesen."), false, false, 0);
            }
            case 3: {
                return this.handleCallback(i18n.tr("Bitte geben Sie die PIN in Ihren Chipkarten-Leser ein"), true, settings.getBoolean("waitfor.card.pin", false), 2);
            }
            case 5: {
                return this.handleCallback(i18n.tr("PIN wurde eingegeben."), false, false, 0);
            }
            case 15: {
                return this.handleCallback(i18n.tr("Bitte entfernen Sie die Chipkarte aus dem Leseger\u00e4t."), false, settings.getBoolean("waitfor.card.eject", false), 2);
            }
        }
        return false;
    }

    private boolean handleCallback(String text, boolean displayKonto, boolean wait, int type) throws Exception {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
        if (displayKonto) {
            Konto konto;
            Konto konto2 = konto = session != null ? session.getKonto() : null;
            if (konto != null) {
                text = String.valueOf(text) + ". " + konto.getLongName();
            }
        }
        if (wait) {
            Application.getCallback().notifyUser(text);
        } else {
            if (session != null) {
                session.getProgressMonitor().setStatusText(text);
            }
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, type));
        }
        return true;
    }
}

