/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.ddv.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passport.Configuration;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfig;
import de.willuhn.jameica.hbci.passports.ddv.DDVConfigFactory;
import de.willuhn.jameica.hbci.passports.ddv.View;
import de.willuhn.jameica.hbci.passports.ddv.rmi.Passport;
import de.willuhn.jameica.hbci.passports.ddv.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class PassportImpl
extends UnicastRemoteObject
implements Passport {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Konto konto = null;

    @Override
    public PassportHandle getHandle() throws RemoteException {
        return new PassportHandleImpl(this.konto);
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Chipkartenleser");
    }

    @Override
    public String getInfo() throws RemoteException {
        List<DDVConfig> list = DDVConfigFactory.getConfigs();
        if (list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return i18n.tr("vorhandener Kartenleser: {0}", list.get(0).getReaderPreset().getName());
        }
        return i18n.tr("vorhandene Kartenleser-Konfigurationen: {0}", Integer.toString(list.size()));
    }

    @Override
    public List<? extends Configuration> getConfigurations() throws RemoteException {
        return DDVConfigFactory.getConfigs();
    }

    @Override
    public Class getConfigDialog() throws RemoteException {
        return View.class;
    }

    @Override
    public void init(Konto konto) throws RemoteException {
        this.konto = konto;
    }
}

