/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.SmartCardUtil;
import de.willuhn.jameica.hbci.passports.pintan.TANDialog;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.kapott.hbci.manager.FlickerRenderer;
import org.kapott.hbci.smartcardio.ChipTanCardService;

public class ChipTANDialog
extends TANDialog {
    private static final Settings SETTINGS = new Settings(ChipTANDialog.class);
    private static final String PARAM_AUTOCONTINUE = "usb.autocontinue";
    private static final String PARAM_AUTOPLAY = "flicker.autoplay";
    private String code = null;
    private boolean usb = false;
    private boolean run = true;
    private ChipTanCardService service = null;
    private CheckboxInput autoContinue = null;
    private final Listener resizeListener = new DelayedListener(new Listener(){

        public void handleEvent(Event event) {
            ChipTANDialog.this.storeSize();
        }
    });

    public ChipTANDialog(PinTanConfig config, String code) throws RemoteException, ApplicationException {
        super(config);
        this.code = code;
        this.run = SETTINGS.getBoolean(PARAM_AUTOPLAY, true);
        this.checkUSB();
        Logger.info((String)("using chiptan " + (this.usb ? "USB" : "OPTIC")));
        if (this.usb) {
            this.setSideImage(SWTUtil.getImage((String)"cardreader.png"));
        } else {
            this.setSideImage(null);
        }
    }

    @Override
    public void setText(String text) {
        if ((text = StringUtils.trimToNull((String)text)) != null) {
            String nums;
            String token2 = "CHLGTEXT";
            int t1Start = text.indexOf("CHLGUC");
            int t2Start = text.indexOf("CHLGTEXT");
            if (t1Start == -1 || t2Start == -1 || t2Start <= t1Start) {
                super.setText(text);
                return;
            }
            if ((text = text.substring(t2Start + "CHLGTEXT".length())).length() > 4 && (nums = text.substring(0, 4)).matches("[0-9]{4}")) {
                text = text.substring(4);
            }
        }
        super.setText(text);
    }

    private CheckboxInput getAutoContinue() throws RemoteException {
        if (this.autoContinue != null) {
            return this.autoContinue;
        }
        this.autoContinue = new CheckboxInput(SETTINGS.getBoolean(PARAM_AUTOCONTINUE, false));
        this.autoContinue.setName(i18n.tr("Bei Erhalt der TAN automatisch fortsetzen"));
        this.autoContinue.addListener(new Listener(){

            public void handleEvent(Event event) {
                SETTINGS.setAttribute(ChipTANDialog.PARAM_AUTOCONTINUE, ((Boolean)ChipTANDialog.this.autoContinue.getValue()).booleanValue());
            }
        });
        return this.autoContinue;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        super.paint(parent);
        int windowWidth = SETTINGS.getInt("window.width", 0);
        int windowHeight = SETTINGS.getInt("window.height", 0);
        if (windowWidth > 0 && windowHeight > 0) {
            this.setSize(windowWidth, windowHeight);
        }
        this.getShell().addListener(11, this.resizeListener);
    }

    private void storeSize() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Point p = shell.getSize();
        if (p == null) {
            return;
        }
        Logger.debug((String)("saving window size: " + p.x + "x" + p.y));
        SETTINGS.setAttribute("window.width", p.x);
        SETTINGS.setAttribute("window.height", p.y);
    }

    private void checkUSB() throws RemoteException {
        Boolean use;
        PtSecMech mech;
        PtSecMech ptSecMech = mech = this.config != null ? this.config.getCurrentSecMech() : null;
        if (mech == null || !mech.isFlickerCode()) {
            return;
        }
        if (this.config != null && this.config.isConvertFlickerToQRCode()) {
            return;
        }
        Boolean bl = use = this.config != null ? this.config.isChipTANUSB() : null;
        if (use != null && !use.booleanValue()) {
            return;
        }
        try {
            Logger.info((String)"searching for smartcards, please wait...");
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Legen Sie bitte die Chipkarte ein."), 2));
            this.service = SmartCardUtil.getService(this.config != null ? this.config.getCardReader() : null);
            if (this.service != null && this.config != null) {
                Logger.info((String)("found smartcard, to be used: " + (use != null ? use : "<asking user>")));
                if (use != null && use.booleanValue()) {
                    this.usb = this.config.isChipTANUSB();
                    return;
                }
                this.usb = Application.getCallback().askUser(i18n.tr("Es wurde ein USB-Kartenleser gefunden.\nM\u00f6chten Sie diesen zur Erzeugung der TAN verwenden?"), false);
                this.config.setChipTANUSB(this.usb);
            }
        }
        catch (Throwable t) {
            Logger.info((String)("no chipcard reader found, chipTAN USB not available: " + t.getMessage()));
            Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)t);
        }
    }

    @Override
    protected void extendTop(Container container) throws Exception {
        if (this.usb) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Legen Sie bitte die Chipkarte ein."), 2));
            this.setInfoText(NotificationPanel.Type.INFO, i18n.tr("Legen Sie bitte die Chipkarte ein."));
            this.setShowTAN(true);
            container.addText(i18n.tr("Legen Sie die Chipkarte ein und folgen Sie den Anweisungen des Kartenlesers. Klicken Sie auf \"OK\", wenn die TAN korrekt \u00fcbertragen wurde."), true);
            ProgressBar progress = new ProgressBar(container.getComposite(), 2);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            progress.setLayoutData((Object)gd);
            final AtomicBoolean cancelled = new AtomicBoolean(false);
            final Thread usbThread = new Thread(){

                @Override
                public void run() {
                    block3: {
                        try {
                            Logger.info((String)"trying to get TAN using USB cardreader");
                            String s = StringUtils.trimToNull((String)ChipTANDialog.this.service.getTan(ChipTANDialog.this.code));
                            if (s == null || s.length() <= 0 || cancelled.get()) {
                                throw new Exception(i18n.tr("Keine TAN \u00fcbertragen"));
                            }
                            ChipTANDialog.this.applyTAN(s);
                        }
                        catch (Exception e) {
                            if (cancelled.get()) break block3;
                            Logger.error((String)"unable to get tan from chipcard", (Throwable)e);
                            ChipTANDialog.this.setInfoText(NotificationPanel.Type.ERROR, i18n.tr("Fehler bei TAN-Ermittlung: {0}", e.getMessage()));
                        }
                    }
                }
            };
            usbThread.start();
            this.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    cancelled.set(true);
                    try {
                        if (usbThread != null) {
                            usbThread.interrupt();
                        }
                    }
                    catch (Throwable th) {
                        Logger.error((String)"unable to interrupt USB thread", (Throwable)th);
                    }
                }
            });
        } else {
            this.setInfoText(NotificationPanel.Type.INFO, i18n.tr("Klicken Sie \"-\" bzw. \"+\", um die Breite anzupassen."));
            SimpleContainer c = new SimpleContainer(container.getComposite(), false, 1);
            Composite comp = new Composite(c.getComposite(), 0);
            GridData gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            comp.setLayoutData((Object)gd);
            comp.setLayout((Layout)new GridLayout(1, false));
            FlickerPart flicker = new FlickerPart(this.code);
            flicker.paint(comp);
        }
    }

    private void applyTAN(final String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ChipTANDialog.this.setTAN(s);
                if (SETTINGS.getBoolean(ChipTANDialog.PARAM_AUTOCONTINUE, false)) {
                    ChipTANDialog.this.close();
                }
            }
        });
    }

    @Override
    protected void extendBottom(Container c) throws Exception {
        if (!this.usb) {
            return;
        }
        c.addInput((Input)this.getAutoContinue());
    }

    private class FlickerPart
    extends FlickerRenderer
    implements Part {
        private Composite comp;
        private Canvas canvas;
        private boolean[] bits;
        private Color black;
        private Color white;
        private Button play;

        private FlickerPart(String code) throws ApplicationException {
            super(code);
            this.comp = null;
            this.canvas = null;
            this.bits = new boolean[5];
            this.black = GUI.getDisplay().getSystemColor(2);
            this.white = GUI.getDisplay().getSystemColor(1);
            this.play = null;
            this.setFrequency(SETTINGS.getInt("freq", 10));
        }

        public void paint(boolean b1, boolean b2, boolean b3, boolean b4, boolean b5) {
            this.bits[0] = b1;
            this.bits[1] = b2;
            this.bits[2] = b3;
            this.bits[3] = b4;
            this.bits[4] = b5;
            if (this.canvas == null || this.canvas.isDisposed()) {
                return;
            }
            this.canvas.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (FlickerPart.this.canvas.isDisposed()) {
                        return;
                    }
                    FlickerPart.this.canvas.redraw();
                }
            });
        }

        public void paint(final Composite parent) throws RemoteException {
            if (this.canvas != null) {
                return;
            }
            Composite buttonComp = new Composite(parent, 0);
            GridData buttonGd = new GridData();
            buttonGd.grabExcessHorizontalSpace = true;
            buttonGd.horizontalAlignment = 0x1000000;
            buttonComp.setLayoutData((Object)buttonGd);
            buttonComp.setLayout((Layout)new GridLayout(5, false));
            Label label1 = new Label(buttonComp, 0);
            label1.setLayoutData((Object)new GridData());
            label1.setText(i18n.tr("Breite"));
            org.eclipse.swt.widgets.Button smaller = new org.eclipse.swt.widgets.Button(buttonComp, 8);
            smaller.setToolTipText(i18n.tr("Flicker-Code verkleinern"));
            smaller.setLayoutData((Object)new GridData());
            smaller.setText(" - ");
            smaller.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GridData gd = (GridData)FlickerPart.this.comp.getLayoutData();
                    if (gd.widthHint < SWTUtil.mm2px((int)20)) {
                        return;
                    }
                    gd.widthHint -= 8;
                    Point newSize = new Point(gd.widthHint, FlickerPart.this.comp.getSize().y);
                    FlickerPart.this.comp.setSize(newSize);
                    parent.layout();
                }
            });
            org.eclipse.swt.widgets.Button larger = new org.eclipse.swt.widgets.Button(buttonComp, 8);
            larger.setToolTipText(i18n.tr("Flicker-Code vergr\u00f6\u00dfern"));
            larger.setLayoutData((Object)new GridData());
            larger.setText(" + ");
            larger.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GridData gd = (GridData)FlickerPart.this.comp.getLayoutData();
                    if (gd.widthHint > SWTUtil.mm2px((int)400)) {
                        return;
                    }
                    gd.widthHint += 8;
                    Point newSize = new Point(gd.widthHint, FlickerPart.this.comp.getSize().y);
                    FlickerPart.this.comp.setSize(newSize);
                    parent.layout();
                }
            });
            Label label2 = new Label(buttonComp, 0);
            label2.setLayoutData((Object)new GridData());
            label2.setText(i18n.tr("Geschwindigkeit"));
            final Spinner spinner = new Spinner(buttonComp, 2048);
            spinner.setToolTipText(i18n.tr("Geschwindigkeit in Hz (1/Sekunde)"));
            spinner.setLayoutData((Object)new GridData());
            spinner.setSelection(SETTINGS.getInt("freq", 14));
            spinner.setMinimum(2);
            spinner.setMaximum(40);
            spinner.setIncrement(1);
            spinner.setTextLimit(2);
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int freq = spinner.getSelection();
                    SETTINGS.setAttribute("freq", freq);
                    FlickerPart.this.setFrequency(freq);
                }
            });
            this.comp = new Composite(parent, 2048);
            this.comp.setBackground(GUI.getDisplay().getSystemColor(2));
            final GridData gd = new GridData(64);
            int width = SWTUtil.mm2px((int)60);
            if (width == -1) {
                width = 206;
            }
            gd.widthHint = SETTINGS.getInt("width", width);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 0x1000000;
            int height = SWTUtil.mm2px((int)40);
            if (height == -1) {
                height = 100;
            }
            gd.heightHint = height;
            this.comp.setLayoutData((Object)gd);
            GridLayout gl = new GridLayout();
            gl.marginHeight = 20;
            gl.marginWidth = 20;
            this.comp.setLayout((Layout)gl);
            this.comp.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Logger.info((String)("saving width of flickercode: " + gd.widthHint + " px"));
                    SETTINGS.setAttribute("width", gd.widthHint);
                }
            });
            this.canvas = new Canvas(this.comp, 0);
            this.canvas.setBackground(GUI.getDisplay().getSystemColor(2));
            this.canvas.setLayoutData((Object)new GridData(1808));
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    FlickerPart.this.update(e.gc);
                }
            });
            this.canvas.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FlickerPart.this.stop();
                }
            });
            Composite playComp = new Composite(parent, 0);
            GridData playGd = new GridData();
            playGd.grabExcessHorizontalSpace = true;
            playGd.horizontalAlignment = 0x1000000;
            playComp.setLayoutData((Object)playGd);
            playComp.setLayout((Layout)new GridLayout(2, false));
            this.play = new Button("", new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    FlickerPart.this.updatePlay();
                }
            }, null, false, ChipTANDialog.this.run ? "media-playback-stop.png" : "media-playback-start.png");
            final CheckboxInput autorun = new CheckboxInput(ChipTANDialog.this.run);
            autorun.addListener(new Listener(){

                public void handleEvent(Event event) {
                    Boolean b = (Boolean)autorun.getValue();
                    SETTINGS.setAttribute(ChipTANDialog.PARAM_AUTOPLAY, b.booleanValue());
                }
            });
            autorun.setName(i18n.tr("Automatisch starten"));
            this.play.paint(playComp);
            autorun.paint(playComp);
            if (ChipTANDialog.this.run) {
                this.start();
            }
        }

        private void updatePlay() {
            if (this.play == null) {
                return;
            }
            ChipTANDialog.this.run = !ChipTANDialog.this.run;
            this.play.setIcon(ChipTANDialog.this.run ? "media-playback-stop.png" : "media-playback-start.png");
            if (ChipTANDialog.this.run) {
                this.start();
            } else {
                this.stop();
            }
        }

        private void update(GC ctx) {
            int barwidth = this.canvas.getSize().x / 5;
            int margin = barwidth / 4;
            barwidth -= margin;
            barwidth += margin / 4;
            Point size = this.canvas.getSize();
            int i = 0;
            while (i < this.bits.length) {
                ctx.setBackground(this.bits[i] ? this.white : this.black);
                ctx.fillRectangle(i * (barwidth + margin), 12, barwidth, size.y - 12);
                ++i;
            }
            ctx.setBackground(this.white);
            int width = 12;
            int height = 6;
            int gap = barwidth / 2 - width / 2;
            int[] nArray = new int[6];
            nArray[0] = gap;
            nArray[2] = gap + width;
            nArray[4] = gap + width / 2;
            nArray[5] = height;
            int[] left = nArray;
            int[] nArray2 = new int[6];
            nArray2[0] = size.x - gap - width;
            nArray2[2] = size.x - gap;
            nArray2[4] = size.x - gap - width / 2;
            nArray2[5] = height;
            int[] right = nArray2;
            ctx.fillPolygon(left);
            ctx.fillPolygon(right);
        }
    }
}

