/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.IntegerInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.action.PassportChange;
import de.willuhn.jameica.hbci.gui.action.PassportSync;
import de.willuhn.jameica.hbci.gui.action.PassportTest;
import de.willuhn.jameica.hbci.gui.dialogs.PassportPropertyDialog;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.HBCIVersionInput;
import de.willuhn.jameica.hbci.passport.PassportChangeRequest;
import de.willuhn.jameica.hbci.passports.pintan.Detail;
import de.willuhn.jameica.hbci.passports.pintan.KontoList;
import de.willuhn.jameica.hbci.passports.pintan.PinTanConfigFactory;
import de.willuhn.jameica.hbci.passports.pintan.PinTanMigrationService;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMechDeleteSettings;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMechInput;
import de.willuhn.jameica.hbci.passports.pintan.SmartCardUtil;
import de.willuhn.jameica.hbci.passports.pintan.View;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.passports.pintan.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class Controller
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private PinTanConfig config = null;
    private HBCIPassport passport = null;
    private TablePart configList = null;
    private Input url = null;
    private Input blz = null;
    private Input port = null;
    private Input filterType = null;
    private Input hbciVersion = null;
    private Input customerId = null;
    private Input userId = null;
    private Input bezeichnung = null;
    private PtSecMechInput tanMech = null;
    private CheckboxInput showTan = null;
    private SelectInput cardReaders = null;
    private CheckboxInput useUsb = null;
    private CheckboxInput convertQr = null;
    private TablePart kontoList = null;

    public Controller(AbstractView view) {
        super(view);
    }

    public PinTanConfig getConfig() {
        if (this.config == null) {
            this.config = (PinTanConfig)this.getCurrentObject();
        }
        return this.config;
    }

    public TablePart getConfigList() throws RemoteException {
        if (this.configList != null) {
            return this.configList;
        }
        this.configList = new TablePart(PinTanConfigFactory.getConfigs(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                GUI.startView(Detail.class, (Object)context);
            }
        });
        this.configList.addColumn(i18n.tr("Name der Bank"), "bank");
        this.configList.addColumn(i18n.tr("Alias-Name"), "bezeichnung");
        this.configList.addColumn(i18n.tr("Bankleitzahl"), "blz");
        this.configList.addColumn(i18n.tr("URL"), "url");
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("\u00d6ffnen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null) {
                    return;
                }
                try {
                    GUI.startView(Detail.class, (Object)context);
                }
                catch (Exception e) {
                    Logger.error((String)"error while loading config", (Throwable)e);
                    GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Anlegen der Konfiguration"));
                }
            }
        }, "document-open.png"));
        ctx.addItem(new ContextMenuItem(i18n.tr("PIN/TAN-Zugang anlegen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.handleCreate();
            }
        }, "document-new.png"));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("L\u00f6schen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.handleDelete((PinTanConfig)context);
            }
        }, "user-trash-full.png"));
        this.configList.setContextMenu(ctx);
        this.configList.setMulti(false);
        this.configList.setRememberColWidths(true);
        this.configList.setRememberOrder(true);
        this.configList.setSummary(false);
        return this.configList;
    }

    public Input getBLZ() throws RemoteException {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput(this.getConfig().getBLZ());
        this.blz.setEnabled(false);
        this.blz.setName(i18n.tr("Bankleitzahl"));
        this.blz.setMandatory(true);
        return this.blz;
    }

    public TablePart getKontoAuswahl() throws RemoteException {
        if (this.kontoList == null) {
            this.kontoList = new KontoList(this.getConfig());
        }
        return this.kontoList;
    }

    public Input getURL() throws RemoteException {
        if (this.url != null) {
            return this.url;
        }
        this.url = new TextInput(this.getConfig().getURL());
        this.url.setName(i18n.tr("URL des Bank-Servers"));
        this.url.setMandatory(true);
        return this.url;
    }

    public CheckboxInput getShowTan() throws RemoteException {
        if (this.showTan != null) {
            return this.showTan;
        }
        this.showTan = new CheckboxInput(this.getConfig().getShowTan());
        return this.showTan;
    }

    public SelectInput getCardReaders() throws RemoteException {
        if (this.cardReaders != null) {
            return this.cardReaders;
        }
        List<String> available = SmartCardUtil.getAvailable();
        available.add(0, "");
        this.cardReaders = new SelectInput(available, (Object)this.getConfig().getCardReader());
        this.cardReaders.setEditable(true);
        this.cardReaders.setComment(i18n.tr("nur n\u00f6tig, wenn mehrere Leser vorhanden (\"*\" am Anfang/Ende erlaubt)"));
        this.cardReaders.setName(i18n.tr("Identifier des PC/SC-Kartenlesers"));
        return this.cardReaders;
    }

    public CheckboxInput getConvertQr() throws RemoteException {
        if (this.convertQr != null) {
            return this.convertQr;
        }
        this.convertQr = new CheckboxInput(this.getConfig().isConvertFlickerToQRCode());
        this.convertQr.setName(i18n.tr("Flickercode in QR-Code umwandeln"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                try {
                    Boolean enabled = (Boolean)Controller.this.getConvertQr().getValue();
                    Controller.this.getChipTANUSB().setEnabled(enabled == false);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to update checkbox settings", (Throwable)e);
                }
            }
        };
        this.convertQr.addListener(l);
        l.handleEvent(null);
        return this.convertQr;
    }

    public PtSecMechInput getTANMech() throws RemoteException {
        if (this.tanMech != null) {
            return this.tanMech;
        }
        this.tanMech = new PtSecMechInput(this.getConfig());
        return this.tanMech;
    }

    public CheckboxInput getChipTANUSB() throws RemoteException {
        if (this.useUsb != null) {
            return this.useUsb;
        }
        final Boolean b = this.getConfig().isChipTANUSB();
        this.useUsb = new CheckboxInput(b == null || b != false);
        this.useUsb.setName(i18n.tr("Kartenleser per USB zur TAN-Erzeugung verwenden"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                try {
                    Boolean showTan;
                    Button bt;
                    Boolean newValue = (Boolean)Controller.this.getChipTANUSB().getValue();
                    if (event != null && event.type == 13 && (bt = (Button)Controller.this.useUsb.getControl()).getGrayed()) {
                        bt.setGrayed(false);
                        bt.setSelection(true);
                        newValue = Boolean.TRUE;
                    }
                    boolean newState = event != null ? newValue != null && newValue.booleanValue() : b != null && b != false;
                    Controller.this.getCardReaders().setEnabled(newState);
                    Controller.this.getConvertQr().setEnabled(!newState);
                    if (!(newValue == null || !newValue.booleanValue() || event != null && event.type != 13 || (showTan = (Boolean)Controller.this.getShowTan().getValue()) != null && showTan.booleanValue())) {
                        Controller.this.getShowTan().setValue((Object)true);
                        String msg = i18n.tr("Anzeige der TANs aktiviert, damit Sie die korrekte \u00dcbertragung vom Kartenleser pr\u00fcfen k\u00f6nnen");
                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(msg, 2));
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"error while updating cardreader field", (Throwable)re);
                }
            }
        };
        l.handleEvent(null);
        this.useUsb.addListener(l);
        return this.useUsb;
    }

    public Input getBezeichnung() throws RemoteException {
        if (this.bezeichnung != null) {
            return this.bezeichnung;
        }
        this.bezeichnung = new TextInput(this.getConfig().getBezeichnung());
        this.bezeichnung.setComment(i18n.tr("Angabe optional"));
        this.bezeichnung.setName(i18n.tr("Alias-Name"));
        return this.bezeichnung;
    }

    public Input getPort() throws RemoteException {
        if (this.port != null) {
            return this.port;
        }
        this.port = new IntegerInput(this.getConfig().getPort());
        this.port.setName(i18n.tr("TCP-Port des Bank-Servers"));
        this.port.setMandatory(true);
        return this.port;
    }

    public Input getCustomerId() throws RemoteException {
        if (this.customerId != null) {
            return this.customerId;
        }
        this.customerId = new TextInput(this.getConfig().getCustomerId(), 30);
        this.customerId.setName(i18n.tr("Kundenkennung"));
        this.customerId.setMandatory(true);
        return this.customerId;
    }

    public Input getUserId() throws RemoteException {
        if (this.userId != null) {
            return this.userId;
        }
        this.userId = new TextInput(this.getConfig().getUserId(), 30);
        this.userId.setName(i18n.tr("Benutzerkennung"));
        this.userId.setMandatory(true);
        return this.userId;
    }

    public Input getFilterType() throws RemoteException {
        if (this.filterType != null) {
            return this.filterType;
        }
        this.filterType = new SelectInput((Object[])new String[]{"Base64", "None"}, (Object)this.getConfig().getFilterType());
        this.filterType.setComment(i18n.tr("meist Base64"));
        this.filterType.setName(i18n.tr("Filter f\u00fcr \u00dcbertragung"));
        this.filterType.setMandatory(true);
        return this.filterType;
    }

    public Input getHBCIVersion() throws RemoteException {
        if (this.hbciVersion != null) {
            return this.hbciVersion;
        }
        String current = this.getConfig().getHBCIVersion();
        this.hbciVersion = new HBCIVersionInput(this.getHBCIPassport(), current);
        this.hbciVersion.setMandatory(true);
        this.hbciVersion.setName(i18n.tr("HBCI-Version"));
        return this.hbciVersion;
    }

    private HBCIPassport getHBCIPassport() throws RemoteException {
        if (this.passport == null) {
            this.passport = this.config.getPassport();
        }
        return this.passport;
    }

    public synchronized void handleDisplayProperties() {
        try {
            new PassportPropertyDialog(1, this.getHBCIPassport()).open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (ApplicationException e) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(e.getMessage()), 1));
        }
        catch (Throwable t) {
            Logger.error((String)"error while displaying BPD/UPD", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler Anzeigen der BPD/UPD"), 1));
        }
    }

    public synchronized void handleDelete(PinTanConfig config) {
        if (config == null) {
            return;
        }
        try {
            if (!Application.getCallback().askUser(i18n.tr("Wollen Sie diese Konfiguration wirklich l\u00f6schen?"))) {
                return;
            }
            PinTanConfigFactory.delete(config);
            GUI.startView(View.class, null);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Konfiguration gel\u00f6scht"), 0));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while deleting config", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("L\u00f6schen fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }

    public synchronized void handleSync() {
        try {
            if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher?"))) {
                return;
            }
            if (!this.handleStore()) {
                return;
            }
            PinTanConfig config = this.getConfig();
            config.reload();
            new PtSecMechDeleteSettings().handleAction(config);
            new PassportSync().handleAction(new PassportHandleImpl(config));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Synchronisieren des Bank-Zugangs: {0}", e.getMessage()), 1));
        }
    }

    public synchronized void handleTest() {
        if (!this.handleStore()) {
            return;
        }
        try {
            PinTanConfig config = this.getConfig();
            config.reload();
            new PassportTest().handleAction(new PassportHandleImpl(config));
        }
        catch (ApplicationException ae) {
            GUI.getStatusBar().setErrorText(ae.getMessage());
        }
        catch (RemoteException e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            GUI.getStatusBar().setErrorText(String.valueOf(i18n.tr("Fehler beim Testen der Konfiguration. Bitte pr\u00fcfen Sie das Protokoll. ")) + e.getMessage());
        }
    }

    public synchronized void handleCreate() {
        block4: {
            PinTanConfig conf = null;
            try {
                Logger.info((String)"creating new pin/tan config");
                conf = PinTanConfigFactory.create();
                GUI.startView(Detail.class, (Object)conf);
                AbstractView view = GUI.getCurrentView();
                if (view != null && view instanceof Detail) {
                    GUI.getStatusBar().setSuccessText(i18n.tr("Konfiguration erfolgreich erstellt. Bitte klicken Sie \"Speichern\" zum \u00dcbernehmen."));
                }
            }
            catch (ApplicationException e) {
                Logger.error((String)"error while creating config", (Throwable)e);
                GUI.getStatusBar().setErrorText(i18n.tr(e.getMessage()));
            }
            catch (Throwable t) {
                if (HBCIProperties.getCause(t, OperationCanceledException.class) != null) break block4;
                Logger.error((String)"error while creating config", (Throwable)t);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Erstellen der Konfiguration"));
            }
        }
    }

    public synchronized boolean handleStore() {
        try {
            Logger.info((String)"storing pin/tan config");
            PinTanConfig config = this.getConfig();
            Konto[] konten = null;
            List checked = this.getKontoAuswahl().getItems();
            if (checked != null && checked.size() > 0) {
                konten = checked.toArray(new Konto[0]);
            }
            config.setKonten(konten);
            String version = (String)this.getHBCIVersion().getValue();
            config.setFilterType((String)this.getFilterType().getValue());
            config.setBezeichnung((String)this.getBezeichnung().getValue());
            config.setShowTan((Boolean)this.getShowTan().getValue());
            config.setHBCIVersion(version);
            config.setURL((String)this.getURL().getValue());
            config.setPort((Integer)this.getPort().getValue());
            config.setCardReader((String)this.getCardReaders().getValue());
            PtSecMech secMech = config.getCurrentSecMech();
            if (secMech != null && secMech.isFlickerCode()) {
                config.setConvertFlickerToQRCode((Boolean)this.getConvertQr().getValue());
                CheckboxInput check = this.getChipTANUSB();
                try {
                    Button button = (Button)check.getControl();
                    if (button != null && !button.isDisposed()) {
                        boolean gray = button.getGrayed();
                        config.setChipTANUSB((Boolean)(gray ? null : check.getValue()));
                    }
                }
                catch (IllegalArgumentException button) {
                    // empty catch block
                }
            }
            AbstractHBCIPassport p = (AbstractHBCIPassport)config.getPassport();
            PassportChangeRequest change = new PassportChangeRequest(p, (String)this.getCustomerId().getValue(), (String)this.getUserId().getValue());
            new PassportChange().handleAction(change);
            if (this.getHBCIVersion().hasChanged()) {
                Logger.info((String)("hbci version has changed to \"" + version + "\" - set sysId to 0 to force BPD reload on next connect"));
                Properties props = p.getBPD();
                if (props != null) {
                    props.remove("BPA.version");
                    p.syncSysId();
                }
            }
            PinTanConfigFactory.store(config);
            this.passport = null;
            GUI.getStatusBar().setSuccessText(i18n.tr("Konfiguration gespeichert"));
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            PinTanMigrationService ps = (PinTanMigrationService)bs.get(PinTanMigrationService.class);
            ps.refresh();
            return true;
        }
        catch (ApplicationException e) {
            Logger.error((String)"error while storing config", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr(e.getMessage()));
        }
        catch (Throwable t) {
            Logger.error((String)"error while creating config", (Throwable)t);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern der Konfiguration"));
        }
        return false;
    }
}

