/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.pintan.Controller;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Button;

public class Detail
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        final Controller control = new Controller(this);
        GUI.getView().setTitle(i18n.tr("Details der PIN/TAN-Konfiguration"));
        ColumnLayout layout = new ColumnLayout(this.getParent(), 2);
        SimpleContainer group = new SimpleContainer(layout.getComposite());
        group.addHeadline(i18n.tr("Verbindungsdaten zur Bank"));
        group.addInput(control.getURL());
        group.addInput(control.getPort());
        group.addInput(control.getFilterType());
        group.addInput(control.getHBCIVersion());
        group = new SimpleContainer(layout.getComposite());
        group.addHeadline(i18n.tr("Benutzerdaten"));
        group.addInput(control.getUserId());
        group.addInput(control.getCustomerId());
        group.addInput(control.getBLZ());
        group = new SimpleContainer(this.getParent());
        group.addHeadline(i18n.tr("Erweiterte Einstellungen"));
        group.addInput(control.getBezeichnung());
        group.addInput((Input)control.getTANMech());
        group.addCheckbox(control.getShowTan(), i18n.tr("TANs w\u00e4hrend der Eingabe anzeigen"));
        PtSecMech secMech = control.getConfig().getCurrentSecMech();
        if (secMech != null && secMech.isFlickerCode()) {
            group.addHeadline(i18n.tr("ChipTAN"));
            group.addText(i18n.tr("Hinweis: Die beiden Optionen zur Umwandlung des Flickercodes in einen QR-Code sowie die Verwendung eines Kartenlesers per USB schlie\u00dfen sich gegenseitig aus.\nSie k\u00f6nnen daher nur eine von beiden Optione w\u00e4hlen."), true, Color.COMMENT);
            group.addInput((Input)control.getConvertQr());
            CheckboxInput check = control.getChipTANUSB();
            group.addInput((Input)check);
            group.addInput((Input)control.getCardReaders());
            if (control.getConfig().isChipTANUSB() == null) {
                Button b = (Button)check.getControl();
                b.setGrayed(true);
            }
        }
        SimpleContainer c = new SimpleContainer(this.getParent(), true);
        c.addHeadline(i18n.tr("Fest zugeordnete Konten"));
        c.addText(i18n.tr("Die folgende Liste enth\u00e4lt alle Konten, welche diesem Bankzugang fest zugeordnet werden k\u00f6nnen. Aktivieren Sie die Kontrollk\u00e4stchen der gew\u00fcnschten Konten in der Spalte \"Kontonummer\", um diese Konten fest zuzuordnen. Klicken Sie anschlie\u00dfend \"Speichern\". Weitere Informationen hierzu finden Sie links in der Hilfe.\n"), true);
        c.addPart((Part)control.getKontoAuswahl());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("BPD/UPD"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleDisplayProperties();
            }
        }, null, false, "document-properties.png");
        buttons.addButton(i18n.tr("Synchronisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleSync();
            }
        }, null, false, "view-refresh.png");
        buttons.addButton(i18n.tr("Konfiguration testen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleTest();
            }
        }, null, false, "dialog-information.png");
        buttons.addButton(i18n.tr("Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, false, "document-save.png");
        buttons.paint(this.getParent());
    }

    public boolean canBookmark() {
        return false;
    }

    public boolean canAttach() {
        return false;
    }
}

