/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.passports.pintan.TANDialog;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PhotoTANDialog
extends TANDialog {
    private static final Settings SETTINGS = new Settings(PhotoTANDialog.class);
    private byte[] bytes = null;
    private int initialSize = 0;
    private int currentSize = 0;
    private Image image = null;
    private Label imageLabel = null;
    private Button smaller = null;
    private Button larger = null;
    private final Listener resizeListener = new DelayedListener(new Listener(){

        public void handleEvent(Event event) {
            PhotoTANDialog.this.storeSize();
        }
    });

    public PhotoTANDialog(PinTanConfig config, byte[] bytes) throws RemoteException, ApplicationException {
        super(config);
        this.bytes = bytes;
    }

    @Override
    protected void extendTop(Container container) throws Exception {
        SimpleContainer c = new SimpleContainer(container.getComposite(), false, 1);
        Composite buttonComp = new Composite(c.getComposite(), 0);
        GridData buttonGd = new GridData();
        buttonGd.horizontalAlignment = 0x1000000;
        buttonComp.setLayoutData((Object)buttonGd);
        buttonComp.setLayout((Layout)new GridLayout(3, true));
        this.smaller = new Button(buttonComp, 8);
        this.smaller.setToolTipText(i18n.tr("Bild verkleinern"));
        this.smaller.setImage(SWTUtil.getImage((String)"list-remove.png"));
        this.smaller.setLayoutData((Object)new GridData());
        this.smaller.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhotoTANDialog.this.resize(PhotoTANDialog.this.currentSize - 30);
            }
        });
        this.smaller.setEnabled(this.currentSize > 30);
        Button reset = new Button(buttonComp, 8);
        reset.setToolTipText(i18n.tr("Originale Bildgr\u00f6\u00dfe wiederherstellen"));
        reset.setImage(SWTUtil.getImage((String)"view-fullscreen.png"));
        reset.setLayoutData((Object)new GridData());
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhotoTANDialog.this.resize(PhotoTANDialog.this.initialSize);
            }
        });
        this.larger = new Button(buttonComp, 8);
        this.larger.setImage(SWTUtil.getImage((String)"list-add.png"));
        this.larger.setToolTipText(i18n.tr("Bild vergr\u00f6\u00dfern"));
        this.larger.setLayoutData((Object)new GridData());
        this.larger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhotoTANDialog.this.resize(PhotoTANDialog.this.currentSize + 30);
            }
        });
        this.larger.setEnabled(this.currentSize < 1000);
        this.image = SWTUtil.getImage((InputStream)new ByteArrayInputStream(this.bytes));
        this.currentSize = this.initialSize = this.image.getBounds().width;
        this.imageLabel = new Label(c.getComposite(), 0);
        GridData gd = new GridData(1808);
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = false;
        this.imageLabel.setLayoutData((Object)gd);
        this.imageLabel.setImage(this.image);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        super.paint(parent);
        int resize = SETTINGS.getInt("resize." + this.initialSize, this.initialSize);
        if (resize <= 0) {
            Logger.warn((String)("ignoring invalid resize value: " + resize + ", using initial size instead: " + this.initialSize));
            resize = this.initialSize;
        }
        this.resize(resize);
        int windowWidth = SETTINGS.getInt("width." + this.initialSize, 0);
        int windowHeight = SETTINGS.getInt("height." + this.initialSize, 0);
        if (windowWidth > 0 && windowHeight > 0) {
            this.setSize(windowWidth, windowHeight);
        } else {
            int width = resize + 100;
            int displayHeight = GUI.getDisplay().getBounds().height;
            Point p = this.getShell().computeSize(width, -1);
            int height = Math.min(p.y, displayHeight);
            this.setSize(width, height);
        }
        this.getShell().addListener(11, this.resizeListener);
    }

    private void storeSize() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Point p = shell.getSize();
        if (p == null) {
            return;
        }
        Logger.debug((String)("saving window size: " + p.x + "x" + p.y));
        SETTINGS.setAttribute("width." + this.initialSize, p.x);
        SETTINGS.setAttribute("height." + this.initialSize, p.y);
    }

    private void resize(int newSize) {
        Image tmp = null;
        try {
            Logger.debug((String)("resize phototan image to new size: " + newSize));
            this.smaller.setEnabled(newSize > 50);
            this.larger.setEnabled(newSize < 1000);
            if (newSize < 1 || newSize > 1000) {
                Logger.warn((String)("got invalid size: " + newSize));
                return;
            }
            try {
                tmp = SWTUtil.getImage((InputStream)new ByteArrayInputStream(this.bytes));
                Rectangle rect = tmp.getBounds();
                Image scaled = new Image((Device)GUI.getDisplay(), newSize, newSize);
                GC gc = new GC((Drawable)scaled);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                gc.drawImage(tmp, 0, 0, rect.width, rect.height, 0, 0, newSize, newSize);
                gc.dispose();
                this.imageLabel.setImage(scaled);
                this.imageLabel.setSize(newSize, newSize);
                this.imageLabel.getParent().layout(true);
                if (this.image != null && !this.image.isDisposed()) {
                    this.image.dispose();
                }
                this.image = scaled;
                Shell shell = this.getShell();
                shell.setSize(shell.computeSize(shell.getSize().x, -1));
                this.currentSize = newSize;
                SETTINGS.setAttribute("resize." + this.initialSize, this.currentSize);
            }
            catch (Exception e) {
                Logger.error((String)"unable to resize photo tan dialog", (Throwable)e);
            }
        }
        finally {
            if (tmp != null && !tmp.isDisposed()) {
                tmp.dispose();
            }
        }
    }
}

