/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.PassportLoader;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passports.pintan.SelectConfigDialog;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.passports.pintan.server.PinTanConfigImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.DBPropertyUtil;
import de.willuhn.jameica.hbci.server.VersionUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Set;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class PinTanConfigFactory {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(PinTanConfigFactory.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static synchronized PinTanConfig create() throws Exception {
        File f = PinTanConfigFactory.createFilename();
        PassportLoader l = PinTanConfigFactory.load(f);
        return new PinTanConfigImpl(l, f);
    }

    public static synchronized void store(PinTanConfig config) throws Exception {
        if (config == null || config.getID() == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu speichernde Konfiguration aus"));
        }
        Logger.info((String)"storing pin/tan config");
        String[] existing = settings.getList("config", new String[0]);
        boolean found = false;
        if (existing != null && existing.length > 0) {
            int i = 0;
            while (i < existing.length) {
                if (existing[i].equals(config.getID())) {
                    Logger.info((String)"updating existing config");
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            Logger.info((String)"adding new pin/tan config");
            String[] newList = new String[existing.length + 1];
            System.arraycopy(existing, 0, newList, 0, existing.length);
            newList[existing.length] = config.getID();
            settings.setAttribute("config", newList);
        }
        HBCIPassport p = config.getPassport();
        Logger.info((String)"saving passport config");
        p.saveChanges();
    }

    public static synchronized void delete(PinTanConfig config) throws ApplicationException {
        try {
            if (config == null || config.getID() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu l\u00f6schende Konfiguration aus"));
            }
            String[] existing = settings.getList("config", new String[0]);
            if (existing.length == 0) {
                Logger.info((String)"no configs found, nothing to delete");
                return;
            }
            Logger.debug((String)("number of configs: " + existing.length));
            ArrayList<String> newList = new ArrayList<String>();
            String id = config.getID();
            int i = 0;
            while (i < existing.length) {
                if (id.equals(existing[i])) {
                    Logger.info((String)("deleting config for file " + id));
                } else {
                    newList.add(existing[i]);
                }
                ++i;
            }
            Logger.debug((String)("new number of configs: " + newList.size()));
            settings.setAttribute("config", newList.toArray(new String[0]));
            File f = new File(config.getFilename());
            if (f.exists() && f.isFile() && f.canWrite()) {
                f.delete();
                Logger.info((String)("deleted passport file " + f));
            }
            Logger.info((String)"deleting BPD/UPD caches");
            try {
                HBCIPassport passport = config.getPassport();
                Set<String> customerIds = HBCIProperties.getCustomerIDs(passport);
                for (String customerId : customerIds) {
                    try {
                        DBPropertyUtil.deleteScope(DBPropertyUtil.Prefix.BPD, customerId);
                        DBPropertyUtil.deleteScope(DBPropertyUtil.Prefix.UPD, customerId);
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while clearing BPD/UPD cache", (Throwable)e);
                    }
                }
                String user = passport.getUserId();
                if (user != null && user.length() > 0) {
                    Logger.info((String)"deleting BPD/UPD cache versions");
                    VersionUtil.delete(Settings.getDBService(), String.valueOf(DBPropertyUtil.Prefix.BPD.value()) + "." + user);
                    VersionUtil.delete(Settings.getDBService(), String.valueOf(DBPropertyUtil.Prefix.UPD.value()) + "." + user);
                }
            }
            catch (Exception exception) {}
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((String)"unable to delete pin/tan config", (Throwable)e);
            throw new ApplicationException(i18n.tr("L\u00f6schen fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    public static PassportLoader load(final File f) {
        HBCIUtils.setParam((String)"client.passport.default", (String)"PinTan");
        HBCIUtils.setParam((String)"client.passport.PinTan.init", (String)"1");
        HBCIUtils.setParam((String)"client.passport.PinTan.checkcert", (String)"1");
        return new PassportLoader(){
            private HBCIPassport p = null;

            @Override
            public void reload() {
                try {
                    try {
                        if (this.p != null) {
                            this.p.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while closing passport", (Throwable)e);
                        this.p = null;
                    }
                }
                finally {
                    this.p = null;
                }
            }

            @Override
            public HBCIPassport load() {
                if (this.p == null) {
                    this.p = AbstractHBCIPassport.getInstance((String)"PinTan", (Object)f);
                }
                return this.p;
            }
        };
    }

    public static synchronized PinTanConfig findByKonto(Konto konto) throws RemoteException, ApplicationException {
        GenericIterator i = PinTanConfigFactory.getConfigs();
        if (!i.hasNext()) {
            throw new ApplicationException(i18n.tr("Bitte legen Sie zuerst eine PIN/TAN-Konfiguration an"));
        }
        Logger.info((String)("searching config for konto " + konto.getKontonummer() + ", blz: " + konto.getBLZ()));
        PinTanConfig config = null;
        ArrayList<PinTanConfig> found = new ArrayList<PinTanConfig>();
        while (i.hasNext()) {
            String blz;
            config = (PinTanConfig)i.next();
            Konto[] verdrahtet = config.getKonten();
            if (konto != null && verdrahtet != null && verdrahtet.length > 0) {
                int j = 0;
                while (j < verdrahtet.length) {
                    Konto k = verdrahtet[j];
                    if (konto.equals((GenericObject)k)) {
                        Logger.info((String)("found config via account. url: " + config.getURL()));
                        return config;
                    }
                    ++j;
                }
            }
            if ((blz = config.getBLZ()) == null || !blz.equals(konto.getBLZ())) continue;
            Logger.info((String)("found config. url: " + config.getURL()));
            found.add(config);
        }
        if (found.size() == 1) {
            config = (PinTanConfig)found.get(0);
            Logger.info((String)("using config. url: " + config.getURL()));
            return config;
        }
        String text = i18n.tr("Mehrere zutreffende Konfigurationen gefunden. Bitte w\u00e4hlen Sie eine manuell aus.");
        if (found.size() == 0) {
            Logger.warn((String)"no config found for this konto. Asking user");
            text = i18n.tr("Keine zutreffende Konfigurationen gefunden. Bitte w\u00e4hlen Sie eine manuell aus.");
        }
        GenericIterator list = PseudoIterator.fromArray((GenericObject[])found.toArray(new PinTanConfig[0]));
        SelectConfigDialog d = new SelectConfigDialog(1, list);
        d.setText(text);
        try {
            config = (PinTanConfig)d.open();
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"error while choosing config", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Auswahl der PIN/TAN-Konfiguration"));
        }
        return config;
    }

    public static synchronized GenericIterator getConfigs() throws RemoteException {
        String[] found = settings.getList("config", new String[0]);
        ArrayList<PinTanConfigImpl> configs = new ArrayList<PinTanConfigImpl>();
        int i = 0;
        while (i < found.length) {
            File f;
            if (found[i] != null && found[i].length() > 0 && (f = PinTanConfigFactory.toAbsolutePath(found[i])).exists()) {
                try {
                    PassportLoader l = PinTanConfigFactory.load(f);
                    configs.add(new PinTanConfigImpl(l, f));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load config " + f.getAbsolutePath() + " - skipping"), (Throwable)e);
                }
            }
            ++i;
        }
        return PseudoIterator.fromArray((GenericObject[])configs.toArray(new PinTanConfig[0]));
    }

    public static File createFilename() throws ApplicationException {
        String wp = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath();
        File f = new File(String.valueOf(wp) + File.separator + "passports", String.valueOf(System.currentTimeMillis()) + ".pt");
        int retry = 0;
        while (f.exists()) {
            if (retry > 20) {
                throw new ApplicationException(i18n.tr("Configdatei {0} existiert bereits", f.getAbsolutePath()));
            }
            f = new File(String.valueOf(wp) + File.separator + "passports", String.valueOf(System.currentTimeMillis()) + "-" + ++retry + ".pt");
        }
        return f;
    }

    public static File toAbsolutePath(String filename) {
        File f = new File(filename);
        if (f.canRead() && f.isFile()) {
            return f;
        }
        String wp = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath();
        return new File(String.valueOf(wp) + File.separator + "passports", filename);
    }

    public static String toRelativePath(String file) {
        return new File(file).getName();
    }
}

