/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.hbci.passports.pintan.PinTanConfigFactory;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class PinTanMigrationService {
    private List<VerificationEntry> entries = new ArrayList<VerificationEntry>();

    @PostConstruct
    private void init() {
        this.refresh();
    }

    public List<VerificationEntry> getConfigs() {
        return this.entries;
    }

    public void refresh() {
        this.entries.clear();
        long started = System.currentTimeMillis();
        try {
            GenericIterator it = PinTanConfigFactory.getConfigs();
            while (it.hasNext()) {
                PinTanConfig conf = (PinTanConfig)it.next();
                try {
                    String newUrl;
                    String url = this.prepareUrl(conf.getURL());
                    String blz = conf.getBLZ();
                    if (StringUtils.trimToNull((String)url) == null || StringUtils.trimToNull((String)blz) == null) {
                        Logger.warn((String)("missing url/blz in pin/tan config - skipping " + conf.getFilename()));
                        continue;
                    }
                    BankInfo info = HBCIUtils.getBankInfo((String)blz);
                    if (info == null || StringUtils.trimToNull((String)(newUrl = this.prepareUrl(info.getPinTanAddress()))) == null || url.equals(newUrl)) continue;
                    VerificationEntry e = new VerificationEntry();
                    e.config = conf;
                    e.newUrl = newUrl;
                    this.entries.add(e);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to load passport", (Throwable)e);
                }
            }
        }
        catch (Exception e2) {
            Logger.error((String)"unable to load passport migration list", (Throwable)e2);
        }
        long used = System.currentTimeMillis() - started;
        Logger.write((Level)(this.entries.isEmpty() ? Level.DEBUG : Level.INFO), (String)("found " + this.entries.size() + " pin/tan configs to be migrated in " + used + " ms"));
    }

    public int migrate(List<VerificationEntry> list) {
        int count = 0;
        if (list == null || list.isEmpty()) {
            return count;
        }
        Logger.info((String)("BEGIN migration of " + list.size() + " pin/tan passports"));
        for (VerificationEntry e : list) {
            try {
                PinTanConfig conf = e.getConfig();
                Logger.info((String)String.format("migrating pin/tan passport '%s' from url '%s' to '%s'", conf.getDescription(), conf.getURL(), e.getNewUrl()));
                conf.setURL(e.getNewUrl());
                PinTanConfigFactory.store(conf);
                ++count;
            }
            catch (Exception ex) {
                Logger.error((String)"unable to migrate pin/tan passport", (Throwable)ex);
            }
        }
        Logger.info((String)("END migration of pin/tan passports: " + count));
        this.refresh();
        return count;
    }

    private String prepareUrl(String url) {
        if (url == null) {
            return url;
        }
        if (url.startsWith("https://")) {
            url = url.substring(8);
        }
        return url;
    }

    public static class VerificationEntry {
        private PinTanConfig config = null;
        private String newUrl = null;

        public PinTanConfig getConfig() {
            return this.config;
        }

        public String getOldUrl() {
            try {
                return this.getConfig().getURL();
            }
            catch (Exception e) {
                Logger.error((String)"unable to get url", (Throwable)e);
                return null;
            }
        }

        public String getNewUrl() {
            return this.newUrl;
        }
    }
}

