/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;

public class PtSecMech {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String id = null;
    private String name = null;

    public static final List<PtSecMech> parse(String text) throws ApplicationException {
        String[] lines;
        if (text == null || text.length() == 0) {
            throw new ApplicationException(i18n.tr("Keine TAN-Verfahren verf\u00fcgbar"));
        }
        ArrayList<PtSecMech> list = new ArrayList<PtSecMech>();
        String[] stringArray = lines = text.split("\\|");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            PtSecMech mech = PtSecMech.create(s);
            if (mech == null) {
                Logger.warn((String)("invalid tan mech: " + s + " - skipping"));
            } else {
                list.add(mech);
            }
            ++n2;
        }
        return list;
    }

    public static PtSecMech contains(String text, String id) {
        if (id == null || text == null) {
            Logger.warn((String)"no tan mechs or no id given");
            return null;
        }
        try {
            List<PtSecMech> list = PtSecMech.parse(text);
            for (PtSecMech p : list) {
                if (!p.getId().equals(id)) continue;
                return p;
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to find tan mech " + id + " in list " + text), (Throwable)e);
            return null;
        }
        Logger.warn((String)("tan mech " + id + " not found in list " + text));
        return null;
    }

    public static PtSecMech create(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        int pos = text.indexOf(":");
        if (pos <= 0) {
            return null;
        }
        PtSecMech result = new PtSecMech();
        result.id = text.substring(0, pos);
        result.name = text.substring(pos + 1);
        return result;
    }

    public static PtSecMech createFailsafe(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        int pos = text.indexOf(":");
        if (pos > 0) {
            return PtSecMech.create(text);
        }
        PtSecMech result = new PtSecMech();
        result.id = text;
        result.name = i18n.tr("TAN-Verfahren");
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLongname() {
        return "[" + this.id + "] " + this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PtSecMech)) {
            return false;
        }
        String id = ((PtSecMech)obj).getId();
        return this.id.equals(id);
    }

    public boolean isFlickerCode() {
        if (this.name == null) {
            return false;
        }
        String s = this.name.toLowerCase();
        return s.contains("usb") || s.contains("optic") || s.contains("optisch") || s.contains("flicker") || s.contains("komfort") || s.contains("comfort") || s.equalsIgnoreCase("chipTAN 1.4");
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.name;
    }
}

