/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class PtSecMechDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings SETTINGS = new Settings(PtSecMechDialog.class);
    private String options = null;
    private SelectInput type = null;
    private CheckboxInput save = null;
    private PinTanConfig config = null;
    private PtSecMech choosen = null;

    public PtSecMechDialog(PinTanConfig config, String options) {
        super(1);
        this.config = config;
        this.options = options;
        String s = null;
        try {
            Konto konto;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
            Konto konto2 = konto = session != null ? session.getKonto() : null;
            if (konto != null) {
                s = konto.getBezeichnung();
                String name = HBCIProperties.getNameForBank(konto.getBLZ());
                if (name != null && name.length() > 0) {
                    s = String.valueOf(s) + " [" + name + "]";
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine current konto", (Throwable)e);
        }
        if (s != null) {
            this.setTitle(i18n.tr("PIN/TAN-Verfahren - Konto {0}", s));
        } else {
            this.setTitle(i18n.tr("Auswahl des PIN/TAN-Verfahrens"));
        }
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie das gew\u00fcnschte PIN/TAN-Verfahren"), true);
        group.addLabelPair(i18n.tr("Bezeichnung"), (Input)this.getType());
        group.addCheckbox(this.getSave(), i18n.tr("Auswahl speichern"));
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    PtSecMechDialog.this.choosen = (PtSecMech)PtSecMechDialog.this.getType().getValue();
                    if (PtSecMechDialog.this.config != null) {
                        PtSecMechDialog.this.config.setCurrentSecMech(PtSecMechDialog.this.choosen);
                    }
                    Boolean b = (Boolean)PtSecMechDialog.this.getSave().getValue();
                    SETTINGS.setAttribute("save", b.booleanValue());
                    if (PtSecMechDialog.this.getSave().isEnabled() && b.booleanValue()) {
                        try {
                            Application.getCallback().notifyUser(i18n.tr("Sie k\u00f6nnen diese Vorauswahl sp\u00e4ter in der PIN/TAN-Konfiguration \u00fcber die Option \"TAN-Verfahren zur\u00fccksetzen\" wieder r\u00fcckg\u00e4ngig machen."));
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to notify user", (Throwable)e);
                        }
                        if (PtSecMechDialog.this.config != null) {
                            PtSecMechDialog.this.config.setStoredSecMech(PtSecMechDialog.this.choosen);
                        }
                    }
                    PtSecMechDialog.this.close();
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to apply data", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehler beim \u00dcbernehmen des PIN/TAN-Verfahrens"));
                }
            }
        }, null, true, "ok.png");
        buttons.addButton((Button)new Cancel());
        group.addButtonArea(buttons);
    }

    protected Object getData() throws Exception {
        if (this.choosen == null) {
            return null;
        }
        return this.choosen.getId();
    }

    private CheckboxInput getSave() {
        if (this.save != null) {
            return this.save;
        }
        this.save = new CheckboxInput(SETTINGS.getBoolean("save", false));
        this.save.setEnabled(this.config != null);
        return this.save;
    }

    private SelectInput getType() throws ApplicationException {
        if (this.type != null) {
            return this.type;
        }
        List<PtSecMech> list = PtSecMech.parse(this.options);
        this.type = new SelectInput(list, null);
        this.type.setAttribute("longname");
        return this.type;
    }
}

