/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMechDeleteSettings;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PtSecMechInput
extends ButtonInput {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private PinTanConfig conf = null;
    private Text label = null;

    public PtSecMechInput(PinTanConfig conf) {
        this.conf = conf;
        this.setName(i18n.tr("Gespeichertes TAN-Verfahren"));
        this.setButtonText(String.valueOf(i18n.tr("TAN-Verfahren zur\u00fccksetzen")) + " ");
        this.disableClientControl();
        this.addButtonListener(e -> {
            try {
                new PtSecMechDeleteSettings().handleAction(conf);
                this.label.setText("");
                this.disableButton();
            }
            catch (Exception ex) {
                Logger.error((String)"error while deleting tan settings", (Throwable)ex);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Zur\u00fccksetzen der TAN-Verfahren"), 1));
            }
        });
        try {
            boolean enabled;
            PtSecMech secMech = this.conf.getCurrentSecMech();
            String tanMedia = this.conf.getTanMedia();
            boolean bl = enabled = secMech != null || tanMedia != null && tanMedia.length() > 0;
            if (enabled) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine pin/tan sec mech", (Throwable)re);
        }
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public Control getClientControl(Composite parent) {
        if (this.label != null) {
            return this.label;
        }
        this.label = GUI.getStyleFactory().createText(parent);
        this.label.setToolTipText(i18n.tr("Wird nur angezeigt, wenn mehrere TAN-Verfahren zur Auswahl stehen und eines davon gespeichert wurde"));
        this.label.setMessage("<" + i18n.tr("Kein TAN-Verfahren gespeichert") + ">");
        try {
            boolean enabled;
            PtSecMech secMech = this.conf.getCurrentSecMech();
            String tanMedia = this.conf.getTanMedia();
            boolean bl = enabled = secMech != null || tanMedia != null && tanMedia.length() > 0;
            if (enabled) {
                StringBuilder sb = new StringBuilder();
                if (secMech != null) {
                    if (tanMedia != null && tanMedia.length() > 0) {
                        sb.append(i18n.tr("Verfahren: {0}", secMech.getName()));
                    } else {
                        sb.append(secMech.getName());
                    }
                }
                if (tanMedia != null && tanMedia.length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(i18n.tr("Medienbezeichnung: {0}", tanMedia));
                }
                this.label.setText(sb.toString());
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine pin/tan sec mech", (Throwable)re);
        }
        return this.label;
    }
}

