/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.pintan.PinTanConfigFactory;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class SelectConfigDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private PinTanConfig selected = null;
    private GenericIterator list = null;
    private String text = null;

    public SelectConfigDialog(int position, GenericIterator list) {
        super(position);
        this.list = list;
        this.setSize(470, 300);
        this.setTitle(i18n.tr("Auswahl der PIN/TAN-Konfiguration"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent, true);
        group.addText(this.text == null ? i18n.tr("Bitte w\u00e4hlen Sie die zu verwendende PIN/TAN-Konfiguration aus") : this.text, true);
        if (this.list != null) {
            this.list.begin();
        }
        final TablePart table = new TablePart(this.list != null && this.list.size() > 0 ? this.list : PinTanConfigFactory.getConfigs(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof PinTanConfig)) {
                    return;
                }
                SelectConfigDialog.this.selected = (PinTanConfig)context;
                SelectConfigDialog.this.close();
            }
        });
        table.addColumn(i18n.tr("Bank"), "bank");
        table.addColumn(i18n.tr("Alias-Name"), "bezeichnung");
        table.addColumn(i18n.tr("URL"), "url");
        table.addColumn(i18n.tr("Kundenkennung"), "customerid");
        table.setMulti(false);
        table.setSummary(false);
        group.addPart((Part)table);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                SelectConfigDialog.this.selected = (PinTanConfig)table.getSelection();
                if (SelectConfigDialog.this.selected == null) {
                    return;
                }
                SelectConfigDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton((Button)new Cancel());
        group.addButtonArea(buttons);
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Object getData() throws Exception {
        return this.selected;
    }
}

