/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.smartcardio.ChipTanCardService;
import org.kapott.hbci.smartcardio.SmartCardService;

public class SmartCardUtil {
    private static final Class<? extends SmartCardService> TYPE = ChipTanCardService.class;

    public static List<String> getAvailable() {
        ArrayList<String> available = new ArrayList<String>();
        try {
            CardTerminals terminals;
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminals cardTerminals = terminals = terminalFactory != null ? terminalFactory.terminals() : null;
            if (terminals == null) {
                return available;
            }
            List<CardTerminal> list = terminals.list();
            if (list != null && list.size() > 0) {
                for (CardTerminal t : list) {
                    String name = StringUtils.trimToNull((String)t.getName());
                    if (name == null) continue;
                    available.add(name);
                }
            }
        }
        catch (Throwable t) {
            Logger.info((String)("unable to determine card reader list: " + t.getMessage()));
            Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)t);
        }
        return available;
    }

    public static ChipTanCardService getService(String name) {
        if ((name = StringUtils.trimToNull((String)name)) == null) {
            return (ChipTanCardService)SmartCardService.createInstance(TYPE, null);
        }
        if (!name.contains("*")) {
            return (ChipTanCardService)SmartCardService.createInstance(TYPE, (String)name);
        }
        boolean starts = name.startsWith("*");
        boolean ends = name.endsWith("*");
        name = name.replace("*", "");
        String match = null;
        for (String s : SmartCardUtil.getAvailable()) {
            if (starts && ends && s.contains(name)) {
                match = s;
                break;
            }
            if (starts && s.startsWith(name)) {
                match = s;
                break;
            }
            if (!starts || !s.endsWith(name)) continue;
            match = s;
            break;
        }
        return match != null ? (ChipTanCardService)SmartCardService.createInstance(TYPE, match) : null;
    }
}

