/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.PasswordInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.NotificationPanel;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.hbci.HBCIContext;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TANDialog
extends AbstractDialog {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    protected static final int WINDOW_WIDTH = 500;
    protected static final int WINDOW_HEIGHT = 550;
    protected PinTanConfig config = null;
    private HibiscusDBObject context = null;
    private NotificationPanel panel = null;
    private PasswordInput tanInput = null;
    private Button okButton = null;
    private String konto = null;
    private String text = null;
    private boolean showTan = true;
    private String tan = null;
    private boolean needTan = true;

    public TANDialog(PinTanConfig config) throws RemoteException {
        super(1);
        this.config = config;
        this.setTitle(this.needTan ? i18n.tr("TAN-Eingabe") : i18n.tr("Auftrag freigeben"));
        this.setText(null);
        this.setSize(500, 550);
        try {
            this.showTan = this.config != null && this.config.getShowTan();
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine if TAN should be shown", (Throwable)e);
        }
        try {
            Konto konto;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
            Konto konto2 = konto = session != null ? session.getKonto() : null;
            if (konto != null) {
                this.konto = konto.getBezeichnung();
                String name = HBCIProperties.getNameForBank(konto.getBLZ());
                if (name != null && name.length() > 0) {
                    this.konto = String.valueOf(this.konto) + " [" + name + "]";
                }
                this.setTitle(i18n.tr(this.needTan ? "TAN-Eingabe - Konto {0}" : "Auftrag freigeben - Konto {0}", this.konto));
            }
            if (session != null) {
                this.addCloseListener(new Listener(){

                    public void handleEvent(Event event) {
                        if (event.detail == 256 && TANDialog.this.context != null) {
                            try {
                                Logger.info((String)("mark job as tan cancelled: " + HBCIContext.toString(TANDialog.this.context)));
                                MetaKey.TAN_CANCEL.set(TANDialog.this.context, HBCI.LONGDATEFORMAT.format(new Date()));
                            }
                            catch (Exception e) {
                                Logger.error((String)"unable to set tan cancel flag in object", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine current konto", (Throwable)e);
        }
    }

    private NotificationPanel getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new NotificationPanel();
        return this.panel;
    }

    private PasswordInput getTANInput() {
        if (this.tanInput != null) {
            return this.tanInput;
        }
        this.tanInput = new PasswordInput(this.tan);
        this.tanInput.setName(i18n.tr("Ihre TAN-Eingabe"));
        this.tanInput.setShowPassword(this.showTan);
        this.tanInput.focus();
        return this.tanInput;
    }

    private Button getOkButton() {
        if (this.okButton != null) {
            return this.okButton;
        }
        this.okButton = new Button("    " + i18n.tr("OK") + "    ", new Action(){

            public void handleAction(Object context) throws ApplicationException {
                TANDialog.this.tan = (String)TANDialog.this.getTANInput().getValue();
                TANDialog.this.close();
            }
        }, null, true, "ok.png");
        this.okButton.setEnabled(!this.needTan);
        return this.okButton;
    }

    protected void paint(Composite parent) throws Exception {
        boolean haveAuftrag;
        SimpleContainer c = new SimpleContainer(parent);
        c.addPart((Part)this.getPanel());
        if (this.needTan) {
            this.setInfoText(NotificationPanel.Type.INFO, i18n.tr("Bitte geben Sie die TAN ein."));
        } else {
            this.setInfoText(NotificationPanel.Type.INFO, i18n.tr("Bitte geben Sie den Auftrag auf Ihrem Smartphone frei."));
        }
        String auftrag = this.context != null ? HBCIContext.toString(this.context) : null;
        boolean bl = haveAuftrag = StringUtils.trimToNull((String)auftrag) != null;
        if (this.konto != null || haveAuftrag) {
            c.addHeadline(i18n.tr("Konto und Auftrag"));
        }
        if (this.konto != null) {
            c.addText(String.valueOf(i18n.tr("Konto")) + ": " + this.konto, true);
        }
        if (haveAuftrag) {
            c.addText(String.valueOf(i18n.tr("Auftrag")) + ": " + auftrag, true);
        }
        this.extendTop((Container)new SimpleContainer(parent, false, 1));
        c = new SimpleContainer(parent, true, 1);
        c.addHeadline(i18n.tr("Informationen der Bank"));
        StyledText msg = new StyledText(c.getComposite(), 2888);
        msg.setText(this.text);
        msg.setLayoutData((Object)new GridData(1808));
        msg.setMargins(5, 5, 5, 5);
        msg.setEditable(false);
        c = new SimpleContainer(parent);
        if (this.needTan) {
            final PasswordInput tan = this.getTANInput();
            c.addInput((Input)tan);
            tan.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    TANDialog.this.getOkButton().setEnabled(StringUtils.trimToNull((String)((String)tan.getValue())) != null);
                }
            });
        }
        this.extendBottom((Container)new SimpleContainer(parent, false, 1));
        SimpleContainer bottom = new SimpleContainer(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.getOkButton());
        buttons.addButton((Button)new Cancel());
        bottom.addButtonArea(buttons);
        this.addShellListener(new ShellListener(){

            public void shellClosed(ShellEvent e) {
                throw new OperationCanceledException("dialog cancelled via close button");
            }

            public void shellActivated(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
        this.getShell().setMinimumSize(this.getShell().computeSize(500, 550));
    }

    protected void extendBottom(Container c) throws Exception {
    }

    protected void extendTop(Container c) throws Exception {
    }

    public final void setTAN(String tan) {
        this.tan = tan;
        this.getTANInput().setValue((Object)tan);
        this.getOkButton().setEnabled(StringUtils.trimToNull((String)tan) != null || !this.needTan);
    }

    public void setShowTAN(boolean show) {
        this.showTan = show;
    }

    public void setNeedTAN(boolean t) {
        this.needTan = t;
    }

    public final void setInfoText(NotificationPanel.Type type, String text) {
        this.getPanel().setText(type, text);
    }

    public void setContext(HibiscusDBObject context) {
        this.context = context;
    }

    public HibiscusDBObject getContext() {
        return this.context;
    }

    protected Object getData() throws Exception {
        return this.tan;
    }

    public void setText(String text) {
        if (text == null || text.length() == 0) {
            text = i18n.tr("Bitte geben Sie eine TAN-Nummer ein.");
        } else {
            text = text.replaceAll("<br>", "\n");
            text = text.replaceAll("<p>", "\n\n");
            text = text.replaceAll("<p>", "\n\n");
            text = text.replaceAll("<ul>", "\n");
            text = text.replaceAll("</ul>", "");
            text = text.replaceAll("<ol>", "\n");
            text = text.replaceAll("</ol>", "");
            text = text.replaceAll("</li>", "\n");
            text = text.replaceAll("<li>", "  - ");
            text = text.replaceAll("<b>", "");
            text = text.replaceAll("</b>", "");
            text = text.replaceAll("<i>", "");
            text = text.replaceAll("</i>", "");
            text = text.replaceAll("<u>", "");
            text = text.replaceAll("</u>", "");
        }
        this.text = text;
    }
}

