/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.swt.widgets.Composite;

public class TanMediaDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private SelectInput media = null;
    private CheckboxInput save = null;
    private PinTanConfig config = null;
    private String options = null;
    private String choosen = null;

    public TanMediaDialog(PinTanConfig config, String options) {
        super(1);
        this.config = config;
        this.options = options;
        String s = null;
        try {
            Konto konto;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
            Konto konto2 = konto = session != null ? session.getKonto() : null;
            if (konto != null) {
                s = konto.getBezeichnung();
                String name = HBCIProperties.getNameForBank(konto.getBLZ());
                if (name != null && name.length() > 0) {
                    s = String.valueOf(s) + " [" + name + "]";
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine current konto", (Throwable)e);
        }
        if (s != null) {
            this.setTitle(i18n.tr("TAN-Medium - Konto {0}", s));
        } else {
            this.setTitle(i18n.tr("Auswahl des TAN-Mediums"));
        }
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie die Bezeichnung des gew\u00fcnschten TAN-Medium aus\noder geben Sie die Bezeichnung neu ein.\n\nBeim smsTAN/mTAN-Verfahren ist das die Bezeichnung (nicht die Telefonnummer)\nIhres Mobiltelefons, die Sie bei Ihrer Bank hinterlegt haben."), true);
        group.addLabelPair(i18n.tr("Bezeichnung"), (Input)this.getMedia());
        group.addCheckbox(this.getSave(), i18n.tr("Auswahl speichern"));
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    TanMediaDialog.this.choosen = (String)TanMediaDialog.this.getMedia().getValue();
                    if (TanMediaDialog.this.choosen != null && TanMediaDialog.this.config != null && TanMediaDialog.this.choosen.length() > 0) {
                        TanMediaDialog.this.config.addTanMedia(TanMediaDialog.this.choosen);
                        Boolean b = (Boolean)TanMediaDialog.this.getSave().getValue();
                        if (TanMediaDialog.this.getSave().isEnabled() && b.booleanValue()) {
                            try {
                                Application.getCallback().notifyUser(i18n.tr("Sie k\u00f6nnen diese Vorauswahl sp\u00e4ter in der PIN/TAN-Konfiguration\n\u00fcber die Option \"TAN-Verfahren zur\u00fccksetzen\" wieder\nr\u00fcckg\u00e4ngig machen."));
                            }
                            catch (Exception e) {
                                Logger.error((String)"unable to notify user", (Throwable)e);
                            }
                            TanMediaDialog.this.config.setTanMedia(TanMediaDialog.this.choosen);
                        }
                    }
                    TanMediaDialog.this.close();
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to apply data", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehler beim \u00dcbernehmen des TAN-Mediums"));
                }
            }
        }, null, true, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        group.addButtonArea(buttons);
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }

    private CheckboxInput getSave() {
        if (this.save != null) {
            return this.save;
        }
        this.save = new CheckboxInput(true);
        this.save.setEnabled(this.config != null);
        return this.save;
    }

    private SelectInput getMedia() throws ApplicationException {
        String s;
        int n;
        int n2;
        String[] stringArray;
        String[] names;
        if (this.media != null) {
            return this.media;
        }
        HashSet<String> set = new HashSet<String>();
        if (this.options != null) {
            stringArray = names = this.options.split("\\|");
            n2 = names.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                set.add(s);
                ++n;
            }
        }
        if (this.config != null) {
            try {
                stringArray = names = this.config.getTanMedias();
                n2 = names.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    set.add(s);
                    ++n;
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to get previous tan medias", (Throwable)e);
            }
        }
        ArrayList result = new ArrayList(set);
        Collections.sort(result);
        this.media = new SelectInput(result, null);
        this.media.setEditable(true);
        return this.media;
    }
}

