/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.gui.action.PassportProcessCode3072;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.passports.pintan.ChipTANDialog;
import de.willuhn.jameica.hbci.passports.pintan.DecoupledTANDialog;
import de.willuhn.jameica.hbci.passports.pintan.FlickerToQrConverter;
import de.willuhn.jameica.hbci.passports.pintan.PhotoTANDialog;
import de.willuhn.jameica.hbci.passports.pintan.PinTanConfigFactory;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMechDialog;
import de.willuhn.jameica.hbci.passports.pintan.SelectConfigDialog;
import de.willuhn.jameica.hbci.passports.pintan.TANDialog;
import de.willuhn.jameica.hbci.passports.pintan.TanMediaDialog;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.passports.pintan.server.PassportImpl;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.HBCIContext;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIVersion;
import org.kapott.hbci.manager.MatrixCode;
import org.kapott.hbci.manager.QRCode;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportHandleImpl
extends UnicastRemoteObject
implements PassportHandle {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private HBCIPassport hbciPassport = null;
    private HBCIHandler handler = null;
    private PassportImpl passport = null;
    private PinTanConfig config = null;

    public PassportHandleImpl(PassportImpl passport) throws RemoteException {
        this.passport = passport;
    }

    public PassportHandleImpl(PinTanConfig config) throws RemoteException {
        this.config = config;
    }

    @Override
    public HBCIHandler open() throws RemoteException, ApplicationException {
        if (this.isOpen()) {
            return this.handler;
        }
        Logger.info((String)"open pin/tan passport");
        try {
            String hbciVersion;
            if (this.config == null && this.passport == null) {
                throw new ApplicationException(i18n.tr("Keine Konfiguration oder Konto ausgew\u00e4hlt"));
            }
            if (this.config == null && this.passport != null && this.passport.getKonto() != null) {
                this.config = PinTanConfigFactory.findByKonto(this.passport.getKonto());
            }
            if (this.config == null) {
                GenericIterator list = PinTanConfigFactory.getConfigs();
                if (list == null || list.size() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte legen Sie zuerst eine PIN/TAN-Konfiguration an"));
                }
                if (list.size() == 1) {
                    this.config = (PinTanConfig)list.next();
                } else {
                    SelectConfigDialog d = new SelectConfigDialog(1, list);
                    try {
                        this.config = (PinTanConfig)d.open();
                    }
                    catch (OperationCanceledException oce) {
                        throw oce;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while choosing config", (Throwable)e);
                        throw new ApplicationException(i18n.tr("Fehler bei der Auswahl der PIN/TAN-Konfiguration"));
                    }
                }
            }
            if (this.config == null) {
                throw new ApplicationException(i18n.tr("Keine PIN/TAN-Konfiguration f\u00fcr dieses Konto definiert"));
            }
            Logger.debug((String)("using passport file " + this.config.getFilename()));
            AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
            HBCICallback callback = ((HBCI)plugin).getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(this);
            }
            this.hbciPassport = this.config.getPassport();
            AbstractHBCIPassport ap = (AbstractHBCIPassport)this.hbciPassport;
            ap.setPersistentData("hibiscus.context.config", (Object)this.config);
            String cannationalacc = this.config.getCustomProperty("cannationalacc");
            if (cannationalacc != null) {
                ap.setPersistentData("cannationalacc", (Object)cannationalacc);
            }
            if ((hbciVersion = this.config.getHBCIVersion()) == null || hbciVersion.length() == 0) {
                hbciVersion = HBCIVersion.HBCI_300.getId();
            }
            Logger.info((String)("[PIN/TAN] url         : " + this.config.getURL()));
            Logger.info((String)("[PIN/TAN] blz         : " + this.config.getBLZ()));
            Logger.info((String)("[PIN/TAN] filter      : " + this.config.getFilterType()));
            Logger.info((String)("[PIN/TAN] HBCI version: " + hbciVersion));
            PtSecMech mech = this.config.getStoredSecMech();
            String secmech = mech != null ? StringUtils.trimToNull((String)mech.getId()) : null;
            Logger.info((String)("[PIN/TAN] using stored tan sec mech: " + (mech != null ? mech.toString() : "<ask-user>")));
            ((AbstractPinTanPassport)this.hbciPassport).setCurrentTANMethod(secmech);
            this.handler = new HBCIHandler(hbciVersion, this.hbciPassport);
            return this.handler;
        }
        catch (OperationCanceledException | ApplicationException | RemoteException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            Logger.error((String)"error while opening pin/tan passport", (Throwable)e);
            throw new RemoteException("error while opening pin/tan passport", e);
        }
    }

    @Override
    public boolean isOpen() throws RemoteException {
        return this.handler != null && this.hbciPassport != null;
    }

    @Override
    public void close() throws RemoteException {
        if (this.hbciPassport == null && this.handler == null) {
            return;
        }
        try {
            this.saveContextData();
            this.handleCode3072();
        }
        finally {
            try {
                Logger.info((String)"closing pin/tan passport");
                this.handler.close();
            }
            catch (Exception plugin) {}
            this.hbciPassport = null;
            this.handler = null;
            AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
            HBCICallback callback = ((HBCI)plugin).getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
            Logger.info((String)"pin/tan passport closed");
        }
    }

    private void saveContextData() {
        if (this.hbciPassport == null) {
            return;
        }
        AbstractHBCIPassport ap = (AbstractHBCIPassport)this.hbciPassport;
        if (this.config == null) {
            this.config = (PinTanConfig)ap.getPersistentData("hibiscus.context.config");
        }
        if (this.config == null) {
            return;
        }
        try {
            String s2;
            String s1 = (String)ap.getPersistentData("hibiscus.context.secmechlist");
            if (s1 != null && s1.length() > 0) {
                this.config.setAvailableSecMechs(s1);
            }
            if ((s2 = (String)ap.getPersistentData("hibiscus.context.tanmedialist")) != null && s2.length() > 0) {
                this.config.setAvailableTanMedias(s2);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to apply context data", (Throwable)e);
        }
    }

    private void handleCode3072() {
        if (this.hbciPassport == null) {
            return;
        }
        try {
            new PassportProcessCode3072().handleAction(this.hbciPassport);
        }
        catch (Exception e) {
            Logger.error((String)"error while applying new user-/customer data", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der ge\u00e4nderten Zugangsdaten: {0}", e.getMessage()), 1));
        }
    }

    @Override
    public Konto[] getKonten() throws RemoteException, ApplicationException {
        Logger.info((String)"reading accounts from pin/tan passport");
        this.open();
        org.kapott.hbci.structures.Konto[] konten = this.hbciPassport.getAccounts();
        if (konten == null || konten.length == 0) {
            Logger.info((String)"no accounts found");
            Konto[] kontoArray = new Konto[]{};
            return kontoArray;
        }
        ArrayList<Konto> result = new ArrayList<Konto>();
        Konto k = null;
        int i = 0;
        while (i < konten.length) {
            k = Converter.HBCIKonto2HibiscusKonto(konten[i], PassportImpl.class);
            Logger.debug((String)("found account " + k.getKontonummer()));
            result.add(k);
            ++i;
        }
        Konto[] kontoArray = result.toArray(new Konto[0]);
        return kontoArray;
        finally {
            try {
                this.close();
            }
            catch (RemoteException remoteException) {}
        }
    }

    @Override
    public boolean callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) throws Exception {
        switch (reason) {
            case 16: {
                retData.replace(0, retData.length(), DialogFactory.getPIN(passport));
                return true;
            }
            case 33: {
                Logger.debug((String)"got phototan code, using phototan dialog");
                MatrixCode code = new MatrixCode(retData.toString());
                PhotoTANDialog dialog = new PhotoTANDialog(this.config, code.getImage());
                dialog.setContext(this.getContext(passport));
                dialog.setText(msg);
                retData.replace(0, retData.length(), (String)dialog.open());
                return true;
            }
            case 34: {
                Logger.debug((String)"got QR tan code, using qrtan dialog");
                QRCode code = new QRCode(retData.toString(), msg);
                PhotoTANDialog dialog = new PhotoTANDialog(this.config, code.getImage());
                dialog.setContext(this.getContext(passport));
                dialog.setText(code.getMessage());
                retData.replace(0, retData.length(), (String)dialog.open());
                return true;
            }
            case 35: {
                Logger.debug((String)"got decoupled tan code, using pushtan 2.0 dialog");
                DecoupledTANDialog dialog = new DecoupledTANDialog(this.config);
                dialog.setContext(this.getContext(passport));
                dialog.setText(msg);
                dialog.open();
                return true;
            }
            case 17: {
                TANDialog dialog = null;
                String flicker = retData.toString();
                if (flicker != null && flicker.length() > 0) {
                    Logger.debug((String)("got flicker code " + flicker));
                    if (this.doConvertFlickerCode()) {
                        try {
                            String qr = FlickerToQrConverter.convert(flicker);
                            retData.replace(0, retData.length(), qr);
                            return this.callback(passport, 34, msg, datatype, retData);
                        }
                        catch (OperationCanceledException oce) {
                            throw oce;
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable create QR Code", (Throwable)e);
                        }
                    }
                    Logger.info((String)"using chiptan OPTIC/USB");
                    dialog = new ChipTANDialog(this.config, flicker);
                }
                if (dialog == null) {
                    Logger.info((String)"using chiptan MANUAL");
                    Logger.debug((String)"using regular tan dialog");
                    dialog = new TANDialog(this.config);
                }
                dialog.setContext(this.getContext(passport));
                dialog.setText(msg);
                retData.replace(0, retData.length(), (String)dialog.open());
                return true;
            }
            case 27: {
                Logger.debug((String)("GOT PIN/TAN secmech list: " + msg + " [" + retData.toString() + "]"));
                ((AbstractHBCIPassport)passport).setPersistentData("hibiscus.context.secmechlist", (Object)retData.toString());
                if (this.config != null) {
                    PtSecMech m;
                    String type;
                    PtSecMech mech = this.config.getStoredSecMech();
                    String string = type = mech != null ? StringUtils.trimToNull((String)mech.getId()) : null;
                    if (type != null && (m = PtSecMech.contains(retData.toString(), type)) != null) {
                        retData.replace(0, retData.length(), type);
                        return true;
                    }
                }
                PtSecMechDialog ptd = new PtSecMechDialog(this.config, retData.toString());
                retData.replace(0, retData.length(), (String)ptd.open());
                return true;
            }
            case 32: {
                Logger.debug((String)("PIN/TAN media name requested: " + msg + " [" + retData.toString() + "]"));
                ((AbstractHBCIPassport)passport).setPersistentData("hibiscus.context.tanmedialist", (Object)retData.toString());
                String media = retData.toString();
                if (media.length() > 0 && !media.contains("|")) {
                    Logger.info((String)("having exactly one TAN media name (provided by institute) - automatically using this: " + media));
                    retData.replace(0, retData.length(), media);
                    return true;
                }
                if (this.config != null && (media = this.config.getTanMedia()) != null && media.length() > 0) {
                    Logger.info((String)("having a stored TAN media name (provided by user) - automatically using this: " + media));
                    retData.replace(0, retData.length(), media);
                    return true;
                }
                Logger.info((String)("asking user for TAN media (options provided by institute: " + media + ")"));
                TanMediaDialog tmd = new TanMediaDialog(this.config, retData.toString());
                retData.replace(0, retData.length(), (String)tmd.open());
                return true;
            }
        }
        return false;
    }

    private HibiscusDBObject getContext(HBCIPassport passport) {
        String externalId;
        block3: {
            externalId = null;
            try {
                if (passport instanceof AbstractHBCIPassport) break block3;
                return null;
            }
            catch (Exception e) {
                Logger.error((String)("unable to load transfer for external id: " + externalId), (Throwable)e);
                return null;
            }
        }
        externalId = (String)((AbstractHBCIPassport)passport).getPersistentData("externalid");
        return HBCIContext.unserialize(externalId);
    }

    private boolean doConvertFlickerCode() throws RemoteException {
        PtSecMech mech;
        PtSecMech ptSecMech = mech = this.config != null ? this.config.getCurrentSecMech() : null;
        if (mech == null || !mech.isFlickerCode()) {
            return false;
        }
        return this.config.isConvertFlickerToQRCode();
    }
}

