/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.pintan.server;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.PassportLoader;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passports.pintan.Detail;
import de.willuhn.jameica.hbci.passports.pintan.PinTanConfigFactory;
import de.willuhn.jameica.hbci.passports.pintan.PtSecMech;
import de.willuhn.jameica.hbci.passports.pintan.rmi.PinTanConfig;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.kapott.hbci.passport.HBCIPassport;

public class PinTanConfigImpl
implements PinTanConfig {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(PinTanConfig.class);
    private PassportLoader loader = null;
    private File file = null;

    public PinTanConfigImpl(PassportLoader loader, File file) throws RemoteException {
        this.loader = loader;
        this.file = file;
    }

    public Object getAttribute(String attribute) throws RemoteException {
        if ("blz".equals(attribute)) {
            return this.getBLZ();
        }
        if ("bank".equals(attribute)) {
            return HBCIProperties.getNameForBank(this.getBLZ());
        }
        if ("url".equals(attribute)) {
            return this.getURL();
        }
        if ("port".equals(attribute)) {
            return this.getPort();
        }
        if ("filtertype".equals(attribute)) {
            return this.getFilterType();
        }
        if ("hbciversion".equals(attribute)) {
            return this.getHBCIVersion();
        }
        if ("customerid".equals(attribute)) {
            return this.getCustomerId();
        }
        if ("userid".equals(attribute)) {
            return this.getUserId();
        }
        if ("bezeichnung".equals(attribute)) {
            return this.getBezeichnung();
        }
        if ("description".equals(attribute)) {
            return this.getDescription();
        }
        if ("showtan".equals(attribute)) {
            return this.getShowTan();
        }
        if ("tanmedia".equals(attribute)) {
            return this.getTanMedia();
        }
        if ("tanmedias".equals(attribute)) {
            return this.getTanMedias();
        }
        return null;
    }

    @Override
    public String getDescription() {
        try {
            boolean haveBank;
            String name = this.getBezeichnung();
            String bank = HBCIProperties.getNameForBank(this.getBLZ());
            String url = this.getURL();
            boolean haveName = name != null && name.trim().length() > 0;
            boolean bl = haveBank = bank != null && bank.length() > 0;
            if (!haveBank && !haveName) {
                return url;
            }
            if (haveBank && haveName) {
                return String.valueOf(name) + " - " + bank;
            }
            if (haveName) {
                return name;
            }
            return bank;
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine name", (Throwable)e);
            try {
                return this.getPassport().getHost();
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determine host", (Throwable)re);
                return "<unknown> (" + re.getMessage() + ")";
            }
        }
    }

    @Override
    public Class getConfigDialog() throws RemoteException {
        return Detail.class;
    }

    @Override
    public void delete() throws ApplicationException {
        PinTanConfigFactory.delete(this);
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"blz", "bank", "url", "port", "filtertype", "hbciversion"};
    }

    public String getID() throws RemoteException {
        return PinTanConfigFactory.toRelativePath(this.getFilename());
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "url";
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null) {
            return false;
        }
        if (this.getID() == null || other.getID() == null) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    @Override
    public String getHBCIVersion() throws RemoteException {
        String ppVersion = StringUtils.trimToNull((String)this.getPassport().getHBCIVersion());
        return settings.getString(String.valueOf(this.getID()) + ".hbciversion", ppVersion != null ? ppVersion : HBCIVersion.HBCI_300.getId());
    }

    @Override
    public void setHBCIVersion(String version) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".hbciversion", version);
    }

    @Override
    public String getURL() throws RemoteException {
        return this.getPassport().getHost();
    }

    @Override
    public void setURL(String url) throws RemoteException {
        if (url == null || url.length() == 0) {
            Logger.warn((String)"no url entered");
            return;
        }
        if (url.startsWith("https://")) {
            Logger.warn((String)"URL entered with https:// prefix, cutting");
            url = url.substring(8);
        }
        Logger.info((String)("saving URL " + url));
        this.getPassport().setHost(url);
    }

    @Override
    public int getPort() throws RemoteException {
        return this.getPassport().getPort();
    }

    @Override
    public void setPort(int port) throws RemoteException {
        this.getPassport().setPort(Integer.valueOf(port));
    }

    @Override
    public String getFilterType() throws RemoteException {
        return this.getPassport().getFilterType();
    }

    @Override
    public void setFilterType(String type) throws RemoteException {
        this.getPassport().setFilterType(type);
    }

    @Override
    public String getBLZ() throws RemoteException {
        return this.getPassport().getBLZ();
    }

    @Override
    public String getCustomerId() throws RemoteException {
        return this.getPassport().getCustomerId();
    }

    @Override
    public void setCustomerId(String customer) throws RemoteException {
        this.getPassport().setCustomerId(customer);
    }

    @Override
    public String getUserId() throws RemoteException {
        return this.getPassport().getUserId();
    }

    @Override
    public void setUserId(String user) throws RemoteException {
        this.getPassport().setUserId(user);
    }

    @Override
    public String getFilename() throws RemoteException {
        return this.file.getAbsolutePath();
    }

    @Override
    public HBCIPassport getPassport() throws RemoteException {
        return this.loader.load();
    }

    @Override
    public String getBezeichnung() throws RemoteException {
        return settings.getString(String.valueOf(this.getID()) + ".bezeichnung", null);
    }

    @Override
    public void setBezeichnung(String bezeichnung) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".bezeichnung", bezeichnung);
    }

    @Override
    public Konto[] getKonten() throws RemoteException {
        String[] ids = settings.getList(String.valueOf(this.getID()) + ".konto", null);
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<String> fixedIds = new ArrayList<String>();
        ArrayList<Konto> konten = new ArrayList<Konto>();
        int i = 0;
        while (i < ids.length) {
            try {
                konten.add((Konto)Settings.getDBService().createObject(Konto.class, ids[i]));
                fixedIds.add(ids[i]);
            }
            catch (ObjectNotFoundException noe) {
                Logger.warn((String)("account " + ids[i] + " does not exist, removing from list"));
            }
            ++i;
        }
        if (fixedIds.size() != ids.length) {
            Logger.info((String)"fixing list of assigned accounts");
            settings.setAttribute(String.valueOf(this.getID()) + ".konto", fixedIds.toArray(new String[0]));
        }
        return konten.toArray(new Konto[0]);
    }

    @Override
    public void setKonten(Konto[] k) throws RemoteException {
        if (k == null || k.length == 0) {
            settings.setAttribute(String.valueOf(this.getID()) + ".konto", null);
            return;
        }
        String[] ids = new String[k.length];
        int i = 0;
        while (i < k.length) {
            ids[i] = k[i].getID();
            ++i;
        }
        settings.setAttribute(String.valueOf(this.getID()) + ".konto", ids);
    }

    @Override
    public PtSecMech getStoredSecMech() throws RemoteException {
        return PtSecMech.create(settings.getString(String.valueOf(this.getID()) + ".secmech", null));
    }

    @Override
    public void setStoredSecMech(PtSecMech mech) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".secmech", mech != null ? mech.toString() : null);
    }

    @Override
    public PtSecMech getCurrentSecMech() throws RemoteException {
        PtSecMech mech = PtSecMech.create(settings.getString(String.valueOf(this.getID()) + ".secmech.current", null));
        return mech != null ? mech : this.getStoredSecMech();
    }

    @Override
    public void setCurrentSecMech(PtSecMech mech) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".secmech.current", mech != null ? mech.toString() : null);
    }

    @Override
    public List<PtSecMech> getAvailableSecMechs() throws RemoteException {
        ArrayList<PtSecMech> result = new ArrayList<PtSecMech>();
        String s = settings.getString(String.valueOf(this.getID()) + ".secmech.list", null);
        if (s == null) {
            return result;
        }
        try {
            result.addAll(PtSecMech.parse(s));
        }
        catch (Exception e) {
            Logger.error((String)"unparsable secmech list", (Throwable)e);
        }
        return result;
    }

    @Override
    public void setAvailableSecMechs(String list) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".secmech.list", list);
    }

    @Override
    public String getCardReader() throws RemoteException {
        return settings.getString(String.valueOf(this.getID()) + ".cardreader", null);
    }

    @Override
    public void setCardReader(String name) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".cardreader", name);
    }

    @Override
    public Boolean isChipTANUSB() throws RemoteException {
        String s = StringUtils.trimToNull((String)settings.getString(String.valueOf(this.getID()) + ".chiptan.usb.enabled", null));
        return s != null ? Boolean.valueOf(s) : null;
    }

    @Override
    public void setChipTANUSB(Boolean b) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".chiptan.usb.enabled", b != null ? b.toString() : null);
    }

    @Override
    public boolean isConvertFlickerToQRCode() throws RemoteException {
        return settings.getBoolean(String.valueOf(this.getID()) + ".chiptan.flicker2qrcode.enabled", false);
    }

    @Override
    public void setConvertFlickerToQRCode(boolean b) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".chiptan.flicker2qrcode.enabled", b);
    }

    @Override
    public String[] getTanMedias() throws RemoteException {
        return settings.getList(String.valueOf(this.getID()) + ".tanmedias", new String[0]);
    }

    @Override
    public void setTanMedias(String[] names) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".tanmedias", names);
    }

    @Override
    public List<String> getAvailableTanMedias() throws RemoteException {
        ArrayList<String> result = new ArrayList<String>();
        String s = settings.getString(String.valueOf(this.getID()) + ".tanmedias.list", null);
        if (s == null) {
            return result;
        }
        try {
            result.addAll(Arrays.asList(s.split("\\|")));
        }
        catch (Exception e) {
            Logger.error((String)"unparsable tan media list", (Throwable)e);
        }
        return result;
    }

    @Override
    public void setAvailableTanMedias(String list) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".tanmedias.list", list);
    }

    @Override
    public void addTanMedia(String name) throws RemoteException {
        if (name == null || name.length() == 0) {
            return;
        }
        String[] current = this.getTanMedias();
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = current;
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!name.equals(s)) {
                list.add(s);
            }
            ++n2;
        }
        list.add(0, name);
        this.setTanMedias(list.toArray(new String[0]));
    }

    @Override
    public String getTanMedia() throws RemoteException {
        return settings.getString(String.valueOf(this.getID()) + ".tanmedia", null);
    }

    @Override
    public void setTanMedia(String name) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".tanmedia", name);
    }

    @Override
    public boolean getShowTan() throws RemoteException {
        return settings.getBoolean(String.valueOf(this.getID()) + ".showtan", true);
    }

    @Override
    public void setShowTan(boolean show) throws RemoteException {
        settings.setAttribute(String.valueOf(this.getID()) + ".showtan", show);
    }

    @Override
    public String getCustomProperty(String name) throws RemoteException {
        if (name == null) {
            return null;
        }
        return settings.getString(String.valueOf(this.getID()) + "." + name, null);
    }

    @Override
    public void setCustomProperty(String name, String value) throws RemoteException {
        if (name == null) {
            return;
        }
        settings.setAttribute(String.valueOf(this.getID()) + "." + name, value);
    }

    @Override
    public void reload() throws RemoteException {
        this.loader.reload();
    }
}

