/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.FileInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.IntegerInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.gui.action.PassportChange;
import de.willuhn.jameica.hbci.gui.action.PassportSync;
import de.willuhn.jameica.hbci.gui.action.PassportTest;
import de.willuhn.jameica.hbci.gui.dialogs.NewKeysDialog;
import de.willuhn.jameica.hbci.gui.dialogs.PassportPropertyDialog;
import de.willuhn.jameica.hbci.gui.input.BLZInput;
import de.willuhn.jameica.hbci.gui.input.HBCIVersionInput;
import de.willuhn.jameica.hbci.passport.PassportChangeRequest;
import de.willuhn.jameica.hbci.passports.rdh.Detail;
import de.willuhn.jameica.hbci.passports.rdh.KontoList;
import de.willuhn.jameica.hbci.passports.rdh.RDHKeyFactory;
import de.willuhn.jameica.hbci.passports.rdh.View;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.TableItem;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class Controller
extends AbstractControl {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private TablePart keyList = null;
    private Input benutzerkennung = null;
    private Input kundenkennung = null;
    private Input blz = null;
    private Input hbciUrl = null;
    private Input hbciPort = null;
    private Input hbciVersion = null;
    private Input alias = null;
    private Input path = null;
    private RDHKey key = null;
    private HBCIPassport passport = null;
    private TablePart kontoList = null;

    public Controller(AbstractView view) {
        super(view);
    }

    public RDHKey getKey() {
        if (this.key != null) {
            return this.key;
        }
        Object o = this.getCurrentObject();
        if (o instanceof RDHKey) {
            this.key = (RDHKey)o;
        }
        return this.key;
    }

    public HBCIPassport getHBCIPassport() throws RemoteException, ApplicationException, OperationCanceledException {
        if (this.passport != null) {
            return this.passport;
        }
        RDHKey key = this.getKey();
        if (key == null) {
            throw new ApplicationException(i18n.tr("Kein Schl\u00fcssel ausgew\u00e4hlt"));
        }
        this.passport = key.load();
        return this.passport;
    }

    public Input getBenutzerkennung() throws RemoteException, ApplicationException {
        if (this.benutzerkennung != null) {
            return this.benutzerkennung;
        }
        this.benutzerkennung = new TextInput(this.getHBCIPassport().getUserId(), 30);
        this.benutzerkennung.setName(i18n.tr("Benutzerkennung"));
        return this.benutzerkennung;
    }

    public Input getKundenkennung() throws RemoteException, ApplicationException {
        if (this.kundenkennung != null) {
            return this.kundenkennung;
        }
        this.kundenkennung = new TextInput(this.getHBCIPassport().getCustomerId(), 30);
        this.kundenkennung.setName(i18n.tr("Kundenkennung"));
        return this.kundenkennung;
    }

    public Input getBLZ() throws RemoteException, ApplicationException {
        if (this.blz != null) {
            return this.blz;
        }
        this.blz = new BLZInput(this.getHBCIPassport().getBLZ());
        this.blz.setEnabled(false);
        this.blz.setName(i18n.tr("Bankleitzahl"));
        return this.blz;
    }

    public Input getAlias() throws RemoteException {
        if (this.alias != null) {
            return this.alias;
        }
        this.alias = new TextInput(this.getKey().getAlias());
        this.alias.setName(i18n.tr("Alias-Name des Schl\u00fcssels"));
        return this.alias;
    }

    public TablePart getKontoAuswahl() throws RemoteException {
        if (this.kontoList == null) {
            this.kontoList = new KontoList(this.getKey());
        }
        return this.kontoList;
    }

    public Input getPath() throws RemoteException {
        if (this.path == null) {
            this.path = new FileInput(this.getKey().getFilename());
            this.path.setEnabled(false);
            this.path.setName(i18n.tr("Pfad zu Schl\u00fcsseldatei"));
        }
        return this.path;
    }

    public Input getHBCIVersion() throws RemoteException, ApplicationException {
        if (this.hbciVersion != null) {
            return this.hbciVersion;
        }
        this.hbciVersion = new HBCIVersionInput(this.getHBCIPassport(), this.getKey().getHBCIVersion());
        this.hbciVersion.setName(i18n.tr("HBCI-Version"));
        return this.hbciVersion;
    }

    public Input getHBCIUrl() throws ApplicationException, RemoteException {
        if (this.hbciUrl != null) {
            return this.hbciUrl;
        }
        this.hbciUrl = new TextInput(this.getHBCIPassport().getHost());
        this.hbciUrl.setName(i18n.tr("Hostname des Bankservers"));
        return this.hbciUrl;
    }

    public Input getHBCIPort() throws ApplicationException, RemoteException {
        if (this.hbciPort != null) {
            return this.hbciPort;
        }
        Integer i = this.getHBCIPassport().getPort();
        this.hbciPort = new IntegerInput(i != null ? i : 3000);
        this.hbciPort.setName(i18n.tr("TCP-Port des Bankservers"));
        this.hbciPort.setComment(i18n.tr("meist \"3000\""));
        return this.hbciPort;
    }

    public TablePart getKeyList() throws RemoteException {
        if (this.keyList != null) {
            return this.keyList;
        }
        this.keyList = new TablePart(RDHKeyFactory.getKeys(), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                GUI.startView(Detail.class, (Object)context);
            }
        });
        this.keyList.addColumn(i18n.tr("Schl\u00fcsseldatei"), "file");
        this.keyList.addColumn(i18n.tr("Alias-Name"), "alias");
        this.keyList.addColumn(i18n.tr("Format"), "format");
        ContextMenu ctx = new ContextMenu();
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("\u00d6ffnen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (context == null) {
                    return;
                }
                try {
                    GUI.startView(Detail.class, (Object)context);
                }
                catch (Exception e) {
                    Logger.error((String)"error while loading rdh key", (Throwable)e);
                }
            }
        }, "document-open.png"));
        ctx.addItem(new ContextMenuItem(i18n.tr("Neuer Schl\u00fcssel..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.startCreate();
            }
        }, "document-new.png"));
        ctx.addItem(new ContextMenuItem(i18n.tr("Schl\u00fcssel importieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Controller.this.startImport();
            }
        }, "stock_keyring.png"));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new ActivateKey(true));
        ctx.addItem((ContextMenuItem)new ActivateKey(false));
        ctx.addItem(ContextMenuItem.SEPARATOR);
        ctx.addItem((ContextMenuItem)new CheckedContextMenuItem(i18n.tr("L\u00f6schen..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    String q = i18n.tr("Wollen Sie diesen Schl\u00fcssel wirklich l\u00f6schen?\nHierbei wird nur die Verkn\u00fcpfung aus Hibiscus entfernt. Die Schl\u00fcsseldatei selbst bleibt erhalten.");
                    if (!Application.getCallback().askUser(q)) {
                        return;
                    }
                    RDHKey k = (RDHKey)context;
                    RDHKeyFactory.removeKey(k);
                    GUI.startView(View.class, null);
                }
                catch (OperationCanceledException e) {
                    Logger.info((String)"operation cancelled");
                    return;
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to delete key", (Throwable)e2);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim L\u00f6schen des Schl\u00fcssels"), 1));
                }
            }
        }, "user-trash-full.png"));
        this.keyList.setContextMenu(ctx);
        this.keyList.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                try {
                    RDHKey key = (RDHKey)item.getData();
                    if (!key.isEnabled()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting key", (Throwable)e);
                }
            }
        });
        this.keyList.setMulti(false);
        this.keyList.setRememberColWidths(true);
        this.keyList.setRememberOrder(true);
        this.keyList.setSummary(false);
        return this.keyList;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void startIniLetter() {
        RDHKey key = this.getKey();
        if (key == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
            return;
        }
        HBCIPassport passport = null;
        try {
            try {
                passport = key.load();
                NewKeysDialog d = new NewKeysDialog(passport);
                d.open();
                return;
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)("operation cancelled: " + oce.getMessage()));
                if (passport == null) return;
                try {
                    passport.close();
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close passport", (Throwable)e);
                }
                return;
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(ae.getMessage()), 1));
                if (passport == null) return;
                try {
                    passport.close();
                    return;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close passport", (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                Logger.error((String)"error while creating ini letter", (Throwable)e);
                GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Erzeugen des INI-Briefs: {0}", e.getMessage()));
                if (passport == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    passport.close();
                    return;
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to close passport", (Throwable)e2);
                }
                return;
            }
        }
        finally {
            if (passport != null) {
                try {
                    passport.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close passport", (Throwable)e);
                }
            }
        }
    }

    public synchronized void changePassword() {
        HBCIPassport passport = null;
        HBCICallback callback = null;
        try {
            try {
                passport = this.getHBCIPassport();
                AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
                callback = ((HBCI)plugin).getHBCICallback();
                if (callback != null && callback instanceof HBCICallbackSWT) {
                    ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl());
                }
                passport.changePassphrase();
                DialogFactory.clearPINCache(passport);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Passwort ge\u00e4ndert"), 0));
            }
            catch (ApplicationException ae) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                if (callback != null && callback instanceof HBCICallbackSWT) {
                    ((HBCICallbackSWT)callback).setCurrentHandle(null);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to change password", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00c4ndern des Passwortes: {0}", e.getMessage()), 1));
                if (callback != null && callback instanceof HBCICallbackSWT) {
                    ((HBCICallbackSWT)callback).setCurrentHandle(null);
                }
            }
        }
        finally {
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
        }
    }

    public synchronized void handleSync() {
        RDHKey key = this.getKey();
        if (key == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
            return;
        }
        HBCIPassport passport = null;
        try {
            if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher?"))) {
                return;
            }
            passport = key.load();
            passport.syncSigId();
            new PassportSync().handleAction(new PassportHandleImpl(key));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Synchronisieren des Bank-Zugangs: {0}", e.getMessage()), 1));
        }
    }

    public synchronized void startImport() {
        FileDialog fd = new FileDialog(GUI.getShell(), 4096);
        fd.setText(i18n.tr("Bitte w\u00e4hlen Sie die zu importierende Schl\u00fcsseldatei"));
        String importFile = fd.open();
        if (importFile == null || importFile.length() == 0) {
            return;
        }
        RDHKeyFactory.importKey(new File(importFile));
        GUI.startView(View.class, null);
    }

    public synchronized void handleTest() {
        if (!this.handleStore()) {
            return;
        }
        try {
            new PassportTest().handleAction(new PassportHandleImpl(this.getKey()));
        }
        catch (ApplicationException ae) {
            GUI.getStatusBar().setErrorText(ae.getMessage());
        }
        catch (RemoteException e) {
            Logger.error((String)"error while testing passport", (Throwable)e);
            GUI.getStatusBar().setErrorText(String.valueOf(i18n.tr("Fehler beim Testen der Konfiguration. Bitte pr\u00fcfen Sie das Protokoll. ")) + e.getMessage());
        }
    }

    public synchronized boolean handleStore() {
        RDHKey key = this.getKey();
        if (key == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
            return false;
        }
        try {
            Konto[] konten = null;
            List checked = this.getKontoAuswahl().getItems();
            if (checked != null && checked.size() > 0) {
                konten = checked.toArray(new Konto[0]);
            }
            key.setKonten(konten);
            key.setHBCIVersion((String)this.getHBCIVersion().getValue());
            key.setAlias((String)this.getAlias().getValue());
            HBCIPassport p = this.getHBCIPassport();
            if (p != null) {
                Integer i;
                String s = (String)this.getHBCIUrl().getValue();
                if (s != null && s.length() > 0) {
                    p.setHost(s);
                }
                if ((i = (Integer)this.getHBCIPort().getValue()) != null) {
                    p.setPort(i);
                }
                p.saveChanges();
            }
            PassportChangeRequest change = new PassportChangeRequest((AbstractHBCIPassport)p, (String)this.getKundenkennung().getValue(), (String)this.getBenutzerkennung().getValue());
            new PassportChange().handleAction(change);
            GUI.getStatusBar().setSuccessText(i18n.tr("Einstellungen gespeichert"));
            return true;
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)("operation cancelled: " + oce.getMessage()));
        }
        catch (ApplicationException e2) {
            Logger.error((String)"error while exporting key", (Throwable)e2);
            GUI.getStatusBar().setErrorText(i18n.tr(e2.getMessage()));
        }
        catch (Exception e) {
            Logger.error((String)"error while storing settings", (Throwable)e);
            GUI.getStatusBar().setErrorText(i18n.tr("Fehler beim Speichern der Einstellungen"));
        }
        return false;
    }

    public synchronized void handleDisplayProperties() {
        try {
            new PassportPropertyDialog(1, this.getHBCIPassport()).open();
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (ApplicationException e) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(e.getMessage()), 1));
        }
        catch (Throwable t) {
            Logger.error((String)"error while displaying BPD/UPD", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler Anzeigen der BPD/UPD"), 1));
        }
    }

    public synchronized void startCreate() {
        try {
            FileDialog dialog = new FileDialog(GUI.getShell(), 8192);
            dialog.setOverwrite(true);
            dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen einen Pfad und Dateinamen, an dem der Schl\u00fcssel gespeichert werden soll."));
            dialog.setFileName("hibiscus-" + System.currentTimeMillis() + ".rdh");
            dialog.setFilterPath(Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath());
            String newFile = dialog.open();
            if (newFile == null || newFile.length() == 0) {
                throw new OperationCanceledException("no key file choosen");
            }
            File newKey = new File(newFile);
            if (RDHKeyFactory.createKey(newKey)) {
                GUI.startView(View.class, null);
            }
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)("operation cancelled: " + oce.getMessage()));
        }
        catch (Throwable t) {
            Logger.error((String)"error while creating key", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erstellen der Schl\u00fcsseldatei"), 1));
        }
    }

    private class ActivateKey
    extends CheckedContextMenuItem {
        private boolean activate;

        public ActivateKey(final boolean activate) {
            super(activate ? i18n.tr("Schl\u00fcssel aktivieren") : i18n.tr("Schl\u00fcssel deaktivieren"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    if (context == null) {
                        return;
                    }
                    try {
                        ((RDHKey)context).setEnabled(activate);
                        GUI.startView(GUI.getCurrentView().getClass(), (Object)GUI.getCurrentView().getCurrentObject());
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while activating rdh key", (Throwable)e);
                    }
                }
            }, activate ? "network-transmit-receive.png" : "network-offline.png");
            this.activate = activate;
        }

        public boolean isEnabledFor(Object o) {
            if (o == null) {
                return false;
            }
            try {
                boolean active = ((RDHKey)o).isEnabled();
                if (this.activate) {
                    return !active;
                }
                return active;
            }
            catch (Exception e) {
                Logger.error((String)"error while checking key state", (Throwable)e);
                return false;
            }
        }
    }
}

