/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.passports.rdh.Controller;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class Detail
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        try {
            final Controller control = new Controller(this);
            GUI.getView().setTitle(i18n.tr("Schl\u00fcssel-Details"));
            ColumnLayout layout = new ColumnLayout(this.getParent(), 2);
            SimpleContainer group = new SimpleContainer(layout.getComposite());
            group.addHeadline(i18n.tr("Verbindungsdaten zur Bank"));
            group.addInput(control.getHBCIUrl());
            group.addInput(control.getHBCIPort());
            group.addInput(control.getHBCIVersion());
            group = new SimpleContainer(layout.getComposite());
            group.addHeadline(i18n.tr("Benutzerdaten"));
            group.addInput(control.getBenutzerkennung());
            group.addInput(control.getKundenkennung());
            group.addInput(control.getBLZ());
            group = new SimpleContainer(this.getParent());
            group.addHeadline(i18n.tr("Erweiterte Einstellungen"));
            group.addInput(control.getAlias());
            group.addInput(control.getPath());
            ButtonArea buttons = new ButtonArea();
            buttons.addButton(i18n.tr("Passwort \u00e4ndern"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.changePassword();
                }
            }, null, false, "stock_keyring.png");
            buttons.addButton(i18n.tr("INI-Brief anzeigen/erzeugen"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.startIniLetter();
                }
            }, null, false, "text-x-generic.png");
            buttons.paint(this.getParent());
            SimpleContainer c = new SimpleContainer(this.getParent(), true);
            c.addHeadline(i18n.tr("Fest zugeordnete Konten"));
            c.addText(i18n.tr("Die folgende Liste enth\u00e4lt alle Konten, welche diesem Bankzugang fest zugeordnet werden k\u00f6nnen. Aktivieren Sie die Kontrollk\u00e4stchen der gew\u00fcnschten Konten in der Spalte \"Kontonummer\", um diese Konten fest zuzuordnen. Klicken Sie anschlie\u00dfend \"Speichern\". Weitere Informationen hierzu finden Sie links in der Hilfe.\n"), true);
            c.addPart((Part)control.getKontoAuswahl());
            ButtonArea buttons2 = new ButtonArea();
            buttons2.addButton(i18n.tr("BPD/UPD"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.handleDisplayProperties();
                }
            }, null, false, "document-properties.png");
            buttons2.addButton(i18n.tr("Synchronisieren"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.handleSync();
                }
            }, null, false, "view-refresh.png");
            buttons2.addButton(i18n.tr("Konfiguration testen"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.handleTest();
                }
            }, null, false, "dialog-information.png");
            buttons2.addButton(i18n.tr("Speichern"), new Action(){

                public void handleAction(Object context) throws ApplicationException {
                    control.handleStore();
                }
            }, null, false, "document-save.png");
            buttons2.paint(this.getParent());
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage("Schl\u00fcsseldatei geladen", 0));
        }
        catch (Exception e) {
            Throwable oce = HBCIProperties.getCause(e, OperationCanceledException.class);
            Throwable ae = HBCIProperties.getCause(e, ApplicationException.class);
            if (oce != null) {
                Logger.info((String)("operation cancelled by user: " + oce.getMessage()));
            } else if (ae != null) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
            } else {
                Logger.error((String)"unable to load key", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Laden des Schl\u00fcssels: {0}", e.getMessage()), 1));
            }
            GUI.startPreviousView();
        }
    }

    public boolean canBookmark() {
        return false;
    }

    public boolean canAttach() {
        return false;
    }
}

