/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.rdh.RDHKeyFactory;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.KeyFormat;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Arrays;
import org.eclipse.swt.widgets.Composite;

public class KeyFormatDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final int WINDOW_WIDTH = 440;
    private static final int WINDOW_HEIGHT = 260;
    private TablePart table = null;
    private KeyFormat choosen = null;
    private LabelInput warn = null;
    private int neededFeature = 2;

    public KeyFormatDialog(int position, int feature) {
        super(position);
        this.neededFeature = feature;
        this.setTitle(i18n.tr("Auswahl des Datei-Formats"));
        this.setSize(440, 260);
    }

    protected void paint(Composite parent) throws Exception {
        this.warn = new LabelInput("");
        this.warn.setName("");
        this.warn.setColor(Color.ERROR);
        Action action = new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Object o = KeyFormatDialog.this.table.getSelection();
                if (o == null || !(o instanceof KeyFormat)) {
                    KeyFormatDialog.this.warn.setValue((Object)i18n.tr("Bitte w\u00e4hlen Sie ein Format aus"));
                    return;
                }
                KeyFormatDialog.this.choosen = (KeyFormat)o;
                KeyFormatDialog.this.close();
            }
        };
        SimpleContainer c = new SimpleContainer(parent, true);
        c.addText(i18n.tr("Bitte w\u00e4hlen Sie das Datei-Format des Schl\u00fcssels"), true);
        c.addInput((Input)this.warn);
        this.table = new TablePart(Arrays.asList(RDHKeyFactory.getKeyFormats(this.neededFeature)), action);
        this.table.addColumn("Bezeichnung", "name");
        this.table.setMulti(false);
        this.table.setRememberColWidths(true);
        this.table.setRememberOrder(true);
        this.table.removeFeature(FeatureSummary.class);
        c.addPart((Part)this.table);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), action, null, false, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("cancelled in key format dialog");
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(440, 260));
    }

    protected Object getData() throws Exception {
        return this.choosen;
    }
}

